/*
 * Decompiled with CFR 0.152.
 */
package nc.block.machine;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import nc.NuclearCraft;
import nc.tile.machine.TileElectricCrusher;
import nc.tile.machine.TileMachineBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class BlockMachine
extends BlockContainer {
    public Random rand = new Random();
    public final boolean isActive;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop;
    public static boolean keepInventory;
    public int guiID;
    public String particleEffect1;
    public String particleEffect2;
    public String field_149768_d;

    public BlockMachine(boolean active, int idgui, String pe1, String pe2, String texturName) {
        super(Material.field_151573_f);
        this.isActive = active;
        this.guiID = idgui;
        this.particleEffect1 = pe1;
        this.particleEffect2 = pe2;
        this.field_149768_d = texturName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("nc:machine/" + this.field_149768_d + "/side");
        this.iconFront = iconRegister.func_94245_a("nc:machine/" + this.field_149768_d + "/front" + (this.isActive ? "Active" : "Idle"));
        this.iconTop = iconRegister.func_94245_a("nc:machine/" + this.field_149768_d + "/top");
        this.iconBottom = iconRegister.func_94245_a("nc:machine/" + this.field_149768_d + "/bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return metadata == 0 && side == 3 ? this.iconFront : (side == metadata ? this.iconFront : (side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.field_149761_L)));
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return super.func_149650_a(par1, random, par3);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    public void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z - 1);
            Block block1 = world.func_147439_a(x, y, z + 1);
            Block block2 = world.func_147439_a(x - 1, y, z);
            Block block3 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)NuclearCraft.instance, (int)this.guiID, (World)world, (int)x, (int)y, (int)z);
        return true;
    }

    public TileEntity func_149915_a(World world, int par1) {
        return new TileElectricCrusher();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.particleEffect1 != "" && this.particleEffect2 != "" && this.isActive) {
            int direction = world.func_72805_g(x, y, z);
            float x1 = (float)x + 0.5f;
            float y1 = (float)y + 0.5f + random.nextFloat() * 0.8f - 0.4f;
            float z1 = (float)z + 0.5f;
            float f = 0.52f;
            float f1 = random.nextFloat() * 0.6f - 0.3f;
            if (direction == 4) {
                world.func_72869_a(this.particleEffect1, (double)(x1 - f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
                world.func_72869_a(this.particleEffect2, (double)(x1 - f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
            } else if (direction == 5) {
                world.func_72869_a(this.particleEffect1, (double)(x1 + f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
                world.func_72869_a(this.particleEffect2, (double)(x1 + f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
            } else if (direction == 2) {
                world.func_72869_a(this.particleEffect1, (double)(x1 + f1), (double)y1, (double)(z1 - f), 0.0, 0.0, 0.0);
                world.func_72869_a(this.particleEffect2, (double)(x1 + f1), (double)y1, (double)(z1 - f), 0.0, 0.0, 0.0);
            } else if (direction == 3) {
                world.func_72869_a(this.particleEffect1, (double)(x1 + f1), (double)y1, (double)(z1 + f), 0.0, 0.0, 0.0);
                world.func_72869_a(this.particleEffect2, (double)(x1 + f1), (double)y1, (double)(z1 + f), 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemstack) {
        int l = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (l == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (l == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (l == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (itemstack.func_82837_s()) {
            ((TileMachineBase)world.func_147438_o(x, y, z)).setGuiDisplayName(itemstack.func_82833_r());
        }
    }

    public static void updateBlockState(boolean active, World worldObj, int xCoord, int yCoord, int zCoord) {
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldBlockID, int oldMetadata) {
        super.func_149749_a(world, x, y, z, oldBlockID, oldMetadata);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int i) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack((Block)this);
    }
}

