/*
 * Decompiled with CFR 0.152.
 */
package nc.block.storage;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import nc.tile.storage.TileStorage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockEnergyStorage
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    public IIcon blockIcon1;
    @SideOnly(value=Side.CLIENT)
    public IIcon blockIcon2;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop1;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop2;
    public String name;

    public BlockEnergyStorage(String nam) {
        super(Material.field_151573_f);
        this.name = nam;
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("nc:storage/" + this.name + "/sideIn");
        this.blockIcon1 = iconRegister.func_94245_a("nc:storage/" + this.name + "/sideOut");
        this.blockIcon2 = iconRegister.func_94245_a("nc:storage/" + this.name + "/sideDisabled");
        this.iconTop = iconRegister.func_94245_a("nc:storage/" + this.name + "/topIn");
        this.iconTop1 = iconRegister.func_94245_a("nc:storage/" + this.name + "/topOut");
        this.iconTop2 = iconRegister.func_94245_a("nc:storage/" + this.name + "/topDisabled");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        TileEntity te = access.func_147438_o(x, y, z);
        if (te instanceof TileStorage) {
            TileStorage t = (TileStorage)access.func_147438_o(x, y, z);
            if (side <= 1) {
                return t.sideMode[side] == 0 ? this.iconTop : (t.sideMode[side] == 1 ? this.iconTop1 : this.iconTop2);
            }
            return t.sideMode[side] == 0 ? this.field_149761_L : (t.sideMode[side] == 1 ? this.blockIcon1 : this.blockIcon2);
        }
        return side <= 1 ? this.iconTop : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side <= 1 ? this.iconTop : this.field_149761_L;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player != null && world.func_147438_o(x, y, z) instanceof TileStorage) {
            TileStorage te = (TileStorage)world.func_147438_o(x, y, z);
            if (world.field_72995_K) {
                if (player.func_70093_af()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + "Energy Stored: " + te.storage.getEnergyStored() + " / " + te.storage.getMaxEnergyStored() + " RF"));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.WHITE + "Mode: " + (te.sideMode[side] == 0 ? "Output" : (te.sideMode[side] == 1 ? "Disabled" : "Input"))));
                }
            }
            if (!player.func_70093_af()) {
                te.incrSide(side);
            }
        }
        return true;
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getDataDrop(world, x, y, z, world.func_147438_o(x, y, z) != null ? world.func_147438_o(x, y, z) : null)});
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getDataDrop(world, x, y, z, world.func_147438_o(x, y, z) != null ? world.func_147438_o(x, y, z) : null);
    }

    public ItemStack getDataDrop(World world, int x, int y, int z, TileEntity t) {
        ItemStack itemStack = new ItemStack((Block)this, 1);
        this.processDrop(world, x, y, z, t, itemStack);
        return itemStack;
    }

    protected void processDrop(World world, int x, int y, int z, TileEntity t, ItemStack drop) {
        NBTTagCompound tag = new NBTTagCompound();
        if (t != null && t instanceof TileStorage) {
            ((TileStorage)t).writeNBT(tag);
        }
        drop.func_77982_d(tag);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        world.func_72921_c(x, y, z, 0, 2);
        TileStorage t = (TileStorage)world.func_147438_o(x, y, z);
        if (t == null) {
            return;
        }
        if (stack.field_77990_d != null) {
            t.readNBT(stack.field_77990_d);
        }
        if (world.field_72995_K) {
            return;
        }
        world.func_147471_g(x, y, z);
    }
}

