/*
 * Decompiled with CFR 0.152.
 */
package nc.container.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import nc.crafting.NCRecipeHelper;
import nc.tile.machine.TileMachineFluidOut;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerMachineFluidOut
extends Container {
    public TileMachineFluidOut entity;
    public NCRecipeHelper recipes;
    public int lastCookTime;
    public int lastEnergy;
    public int lastFluid;
    public double lastEU;
    public double lastSU;
    public int lastGetSpeed;
    public int lastReqEnergy;

    public ContainerMachineFluidOut(InventoryPlayer inventory, TileMachineFluidOut tileentity, NCRecipeHelper recipe) {
        this.entity = tileentity;
        this.recipes = recipe;
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        icrafting.func_71112_a((Container)this, 0, this.entity.cookTime);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            if (this.lastCookTime != this.entity.cookTime) {
                icrafting.func_71112_a((Container)this, 0, this.entity.cookTime);
            }
            if (this.entity.hasEnergy) {
                icrafting.func_71112_a((Container)this, 200, this.entity.energyStorage.getEnergyStored());
                icrafting.func_71112_a((Container)this, 201, this.entity.energyStorage.getEnergyStored() >> 16);
                icrafting.func_71112_a((Container)this, 202, (int)this.entity.getProcessTime);
                icrafting.func_71112_a((Container)this, 203, (int)this.entity.getProcessTime >> 16);
                icrafting.func_71112_a((Container)this, 204, (int)this.entity.getEnergyRequired);
                icrafting.func_71112_a((Container)this, 205, (int)this.entity.getEnergyRequired >> 16);
            }
            if (this.entity.hasUpgrades) {
                icrafting.func_71112_a((Container)this, 100, (int)this.entity.energyUpgrade);
                icrafting.func_71112_a((Container)this, 101, (int)this.entity.energyUpgrade >> 16);
                icrafting.func_71112_a((Container)this, 102, (int)this.entity.speedUpgrade);
                icrafting.func_71112_a((Container)this, 103, (int)this.entity.speedUpgrade >> 16);
            }
            icrafting.func_71112_a((Container)this, 300, this.entity.tank.getFluidAmount());
            icrafting.func_71112_a((Container)this, 301, this.entity.tank.getFluidAmount() >> 16);
        }
        this.lastCookTime = this.entity.cookTime;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int slot, int value) {
        super.func_75137_b(slot, value);
        if (slot == 0) {
            this.entity.cookTime = value;
        }
        if (this.entity.hasEnergy) {
            if (slot == 200) {
                this.lastEnergy = this.upcastShort(value);
            }
            if (slot == 201) {
                this.entity.energy = this.lastEnergy | value << 16;
            }
            if (slot == 202) {
                this.lastGetSpeed = this.upcastShort(value);
            }
            if (slot == 203) {
                this.entity.getProcessTime = this.lastGetSpeed | value << 16;
            }
            if (slot == 204) {
                this.lastReqEnergy = this.upcastShort(value);
            }
            if (slot == 205) {
                this.entity.getEnergyRequired = this.lastReqEnergy | value << 16;
            }
        }
        if (this.entity.hasUpgrades) {
            if (slot == 100) {
                this.lastEU = this.upcastShort(value);
            }
            if (slot == 101) {
                this.entity.energyUpgrade = (int)this.lastEU | value << 16;
            }
            if (slot == 102) {
                this.lastSU = this.upcastShort(value);
            }
            if (slot == 103) {
                this.entity.speedUpgrade = (int)this.lastSU | value << 16;
            }
        }
        if (slot == 300) {
            this.lastFluid = this.upcastShort(value);
        }
        if (slot == 301) {
            this.entity.fluid = this.lastFluid | value << 16;
        }
    }

    public int upcastShort(int input) {
        if (input < 0) {
            input += 65536;
        }
        return input;
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlotNumber) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlotNumber);
        int upgrades = 0;
        if (this.entity.hasUpgrades) {
            upgrades = 2;
        }
        int invStart = this.entity.inputSize + this.entity.outputSize + upgrades;
        int sSlot = this.entity.inputSize + this.entity.outputSize;
        int eSlot = this.entity.inputSize + this.entity.outputSize + 1;
        int invEnd = this.entity.inputSize + this.entity.outputSize + 36 + upgrades;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (clickedSlotNumber >= this.entity.inputSize && clickedSlotNumber < this.entity.inputSize + this.entity.outputSize) {
                if (!this.func_75135_a(itemstack1, invStart, invEnd, true)) {
                    return null;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (clickedSlotNumber > invStart - 1 ? (TileMachineFluidOut.isSpeedUpgrade(itemstack1) && this.entity.hasUpgrades ? !this.func_75135_a(itemstack1, sSlot, sSlot + 1, false) : (TileMachineFluidOut.isEnergyUpgrade(itemstack1) && this.entity.hasUpgrades ? !this.func_75135_a(itemstack1, eSlot, eSlot + 1, false) : (this.entity.isOxygen(itemstack1) && this.entity.isOxidiser() ? !this.func_75135_a(itemstack1, 1, 2, false) : (this.entity.isNeutronCapsule(itemstack1) && this.entity.isIrradiator() ? !this.func_75135_a(itemstack1, 1, 2, false) : (this.entity.isHydrogen(itemstack1) && this.entity.isIoniser() ? !this.func_75135_a(itemstack1, 1, 2, false) : (this.recipes.validInput(itemstack1) ? !this.func_75135_a(itemstack1, 0, this.entity.inputSize, false) : (clickedSlotNumber >= invStart && clickedSlotNumber < invEnd - 9 ? !this.func_75135_a(itemstack1, invEnd - 9, invEnd, false) : clickedSlotNumber >= invEnd - 9 && clickedSlotNumber < invEnd && !this.func_75135_a(itemstack1, invStart, invEnd - 9, false)))))))) : !this.func_75135_a(itemstack1, invStart, invEnd, false)) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return this.entity.func_70300_a(var1);
    }
}

