/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nc.NuclearCraft;
import nc.gui.machine.GuiNuclearFurnace;
import nc.item.NCItems;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class NuclearFurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<nuclearfuelPair> anuclearnuclearfuels;
    public static HashSet<Block> enuclearfuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "nuclearfuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "nuclearsmelting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiNuclearFurnace.class;
    }

    public String getRecipeName() {
        return "Nuclear Furnace";
    }

    public TemplateRecipeHandler newInstance() {
        if (anuclearnuclearfuels == null) {
            NuclearFurnaceRecipeHandler.findnuclearfuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("nuclearsmelting") && ((Object)((Object)this)).getClass() == NuclearFurnaceRecipeHandler.class) {
            Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new NuclearSmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new NuclearSmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("nuclearfuel") && ((Object)((Object)this)).getClass() == NuclearFurnaceRecipeHandler.class) {
            this.loadCraftingRecipes("nuclearsmelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)recipe.getKey()), (ItemStack)ingredient)) continue;
            NuclearSmeltingPair arecipe = new NuclearSmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "nc:textures/gui/nuclearFurnaceNEI.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 192, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 3, 0);
    }

    private static Set<Item> excludednuclearfuels() {
        HashSet<Item> enuclearfuels = new HashSet<Item>();
        enuclearfuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        enuclearfuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        enuclearfuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        enuclearfuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        enuclearfuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        enuclearfuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return enuclearfuels;
    }

    private static void findnuclearfuels() {
        anuclearnuclearfuels = new ArrayList();
        Set<Item> enuclearfuels = NuclearFurnaceRecipeHandler.excludednuclearfuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (enuclearfuels.contains(item.func_77973_b()) || (burnTime = NuclearFurnaceRecipeHandler.getItemBurnTime(item)) <= 0) continue;
            anuclearnuclearfuels.add(new nuclearfuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item == new ItemStack(NCItems.material, 1, 4).func_77973_b() && item.getDamage(itemstack) == 4) {
            return (int)Math.ceil((double)(NuclearCraft.nuclearFurnaceCookSpeed * 32 / NuclearCraft.nuclearFurnaceCookEfficiency) * Math.ceil(300 / NuclearCraft.nuclearFurnaceCookSpeed));
        }
        if (item == new ItemStack(NCItems.material, 1, 5).func_77973_b() && item.getDamage(itemstack) == 5) {
            return (int)Math.ceil((double)(NuclearCraft.nuclearFurnaceCookSpeed * 32 / NuclearCraft.nuclearFurnaceCookEfficiency) * Math.ceil(300 / NuclearCraft.nuclearFurnaceCookSpeed));
        }
        if (item == new ItemStack(NCItems.material, 1, 19).func_77973_b() && item.getDamage(itemstack) == 19) {
            return (int)Math.ceil((double)(NuclearCraft.nuclearFurnaceCookSpeed * 32 / NuclearCraft.nuclearFurnaceCookEfficiency) * Math.ceil(300 / NuclearCraft.nuclearFurnaceCookSpeed));
        }
        if (item == new ItemStack(NCItems.material, 1, 20).func_77973_b() && item.getDamage(itemstack) == 20) {
            return (int)Math.ceil((double)(NuclearCraft.nuclearFurnaceCookSpeed * 32 / NuclearCraft.nuclearFurnaceCookEfficiency) * Math.ceil(300 / NuclearCraft.nuclearFurnaceCookSpeed));
        }
        return 0;
    }

    public static class nuclearfuelPair {
        public PositionedStack stack;
        public int burnTime;

        public nuclearfuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class NuclearSmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public NuclearSmeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)NuclearFurnaceRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NuclearFurnaceRecipeHandler.this.cycleticks / 24, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return NuclearFurnaceRecipeHandler.anuclearnuclearfuels.get((int)(NuclearFurnaceRecipeHandler.this.cycleticks / 24 % NuclearFurnaceRecipeHandler.anuclearnuclearfuels.size())).stack;
        }
    }
}

