/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import cofh.api.energy.ItemEnergyContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import nc.NuclearCraft;
import nc.util.InfoNC;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ItemBattery
extends ItemEnergyContainer {
    String[] info;
    String name;

    public ItemBattery(int storage, String nam, String ... lines) {
        super(storage, storage, storage);
        String[] strings = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            strings[i] = lines[i];
        }
        this.info = strings;
        this.name = nam;
        this.func_77655_b(nam);
    }

    public ItemBattery(int storage, int transfer, String nam, String ... lines) {
        super(storage, transfer, transfer);
        String[] strings = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            strings[i] = lines[i];
        }
        this.info = strings;
        this.name = nam;
        this.func_77655_b(nam);
    }

    public ItemBattery(int storage, int receive, int extract, String nam, String ... lines) {
        super(storage, receive, extract);
        String[] strings = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            strings[i] = lines[i];
        }
        this.info = strings;
        this.name = nam;
        this.func_77655_b(nam);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return NuclearCraft.tabNC;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("nc:batteries/" + this.func_77658_a().substring(5));
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(EnumChatFormatting.LIGHT_PURPLE + "Energy: " + tagCompound.func_74762_e("Energy") + " / " + this.capacity + " RF");
        }
        InfoNC.infoFull(list, this.info);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74762_e("Energy") > 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            return 1.0 - (double)tagCompound.func_74762_e("Energy") / (double)this.capacity;
        }
        return 1.0;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

