/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import nc.NuclearCraft;
import nc.tile.generator.TileSteamDecompressor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileDenseSteamDecompressor
extends TileEntity
implements IFluidHandler {
    public int fluid;
    public FluidTank tank = new FluidTank(NuclearCraft.steamDecompressRate);
    public int fluid2;
    public FluidTank tank2 = new FluidTank(NuclearCraft.steamDecompressRate * 1000);

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.steam();
            this.addSteam();
        }
        this.func_70296_d();
    }

    public void addSteam() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (!(tile instanceof TileSteamDecompressor)) continue;
            this.tank2.drain(((TileSteamDecompressor)tile).fill(side.getOpposite(), this.tank2.drain(this.tank2.getCapacity(), false), true), true);
        }
    }

    public void steam() {
        if (this.tank.getFluidAmount() != 0) {
            if (this.tank.getFluid().getFluid() != NuclearCraft.superdenseSteam && this.tank.getFluid().getFluid() != FluidRegistry.getFluid((String)"superdenseSteam")) {
                this.tank.drain(NuclearCraft.steamDecompressRate, true);
            } else if (this.tank.getFluid().getFluid() == NuclearCraft.superdenseSteam || this.tank.getFluid().getFluid() == FluidRegistry.getFluid((String)"superdenseSteam")) {
                for (int i = 0; i < NuclearCraft.steamDecompressRate && this.tank2.getFluidAmount() <= this.tank2.getCapacity() - 1000 && this.tank.getFluidAmount() != 0; ++i) {
                    this.tank2.fill(new FluidStack(NuclearCraft.denseSteam, 1000), true);
                    this.tank.drain(1, true);
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank2.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank2.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == NuclearCraft.superdenseSteam || fluid == FluidRegistry.getFluid((String)"superdenseSteam");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.tank2.readFromNBT(nbt.func_74775_l("tank2"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.tank.writeToNBT(fluidTag);
        nbt.func_74782_a("tank", (NBTBase)fluidTag);
        this.tank2.writeToNBT(fluidTag);
        nbt.func_74782_a("tank2", (NBTBase)fluidTag);
    }

    public void writeFluid(NBTTagCompound nbt) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.tank.writeToNBT(fluidTag);
        nbt.func_74782_a("tank", (NBTBase)fluidTag);
        this.tank2.writeToNBT(fluidTag);
        nbt.func_74782_a("tank2", (NBTBase)fluidTag);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("fluid", this.tank.getFluidAmount());
        this.fluid = nbtTag.func_74762_e("fluid");
        nbtTag.func_74768_a("fluid2", this.tank.getFluidAmount());
        this.fluid2 = nbtTag.func_74762_e("fluid2");
        this.writeFluid(nbtTag);
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void readFluid(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
        if (nbt.func_74764_b("tank2")) {
            this.tank2.readFromNBT(nbt.func_74775_l("tank2"));
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readFluid(packet.func_148857_g());
        this.func_145839_a(packet.func_148857_g());
    }
}

