/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.generator;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import nc.tile.machine.TileInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileGeneratorInventory
extends TileInventory
implements IEnergyHandler,
IEnergyProvider,
IEnergyConnection {
    public int maxStorage;
    public boolean flag;
    public boolean flag1 = false;
    public int energy;
    public EnergyStorage storage;
    public int[] automation;

    public TileGeneratorInventory(String localName, int energyMax, int slotsNumber) {
        this.storage = new EnergyStorage(energyMax, energyMax);
        this.localizedName = localName;
        this.slots = new ItemStack[slotsNumber];
        int[] a = new int[slotsNumber];
        for (int i = 0; i < a.length; ++i) {
            a[i] = i;
        }
        this.automation = a;
    }

    public void addEnergy() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (tile instanceof IEnergyReceiver) {
                this.storage.extractEnergy(((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), this.storage.extractEnergy(this.storage.getMaxEnergyStored(), true), false), false);
                continue;
            }
            if (!(tile instanceof IEnergyHandler)) continue;
            this.storage.extractEnergy(((IEnergyHandler)tile).receiveEnergy(side.getOpposite(), this.storage.extractEnergy(this.storage.getMaxEnergyStored(), true), false), false);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("storage")) {
            this.storage.readFromNBT(nbt.func_74775_l("storage"));
        }
        this.flag = nbt.func_74767_n("flag");
        this.flag1 = nbt.func_74767_n("flag1");
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= this.slots.length) continue;
            this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.storage.writeToNBT(energyTag);
        nbt.func_74782_a("storage", (NBTBase)energyTag);
        nbt.func_74757_a("flag", this.flag);
        nbt.func_74757_a("flag1", this.flag1);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        if (this.isInventoryNameLocalized()) {
            nbt.func_74778_a("CustomName", this.localizedName);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.storage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        this.writeEnergy(nbtTag);
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readEnergy(packet.func_148857_g());
        this.func_145839_a(packet.func_148857_g());
    }

    public void readEnergy(NBTTagCompound nbt) {
        if (nbt.func_74764_b("storage")) {
            this.storage.readFromNBT(nbt.func_74775_l("storage"));
        }
    }

    public void writeEnergy(NBTTagCompound nbt) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.storage.writeToNBT(fluidTag);
        nbt.func_74782_a("storage", (NBTBase)fluidTag);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection paramForgeDirection) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection paramForgeDirection) {
        return this.storage.getMaxEnergyStored();
    }

    public int[] func_94128_d(int slot) {
        return this.automation;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int par) {
        return this.func_94041_b(slot, stack);
    }
}

