/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.machine;

import cpw.mods.fml.common.registry.GameRegistry;
import nc.NuclearCraft;
import nc.tile.machine.TileInventory;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileFuelUser
extends TileInventory {
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_sides = new int[]{1};
    private static final int[] slots_bottom = new int[]{2};
    public double furnaceSpeed = 8000 / NuclearCraft.metalFurnaceCookSpeed;
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;

    public TileFuelUser(double processTime, String name) {
        this.localizedName = name;
        this.furnaceSpeed = processTime;
        this.slots = new ItemStack[3];
    }

    public String getInvName() {
        return this.isInvNameLocalized() ? this.localizedName : "fuelUser";
    }

    public boolean isInvNameLocalized() {
        return this.localizedName != null && this.localizedName.length() > 0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= this.slots.length) continue;
            this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.burnTime = nbt.func_74765_d("BurnTime");
        this.cookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = nbt.func_74765_d("CurrentBurnTime");
        if (nbt.func_150297_b("CustomName", 8)) {
            this.localizedName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.burnTime);
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        nbt.func_74777_a("CurrentBurnTime", (short)this.currentItemBurnTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        if (this.isInvNameLocalized()) {
            nbt.func_74778_a("CustomName", this.localizedName);
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public void func_145845_h() {
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K && (this.burnTime != 0 || this.slots[1] != null && this.slots[0] != null)) {
            if (this.burnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.burnTime = this.getItemBurnTime(this.slots[1]);
                if (this.burnTime > 0 && this.slots[1] != null) {
                    --this.slots[1].field_77994_a;
                    if (this.slots[1].field_77994_a == 0) {
                        this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.cookTime;
                if ((double)this.cookTime == this.furnaceSpeed) {
                    this.cookTime = 0;
                    this.smeltItem();
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    protected boolean canSmelt() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.slots[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.slots[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
            if (this.slots[2] == null) {
                this.slots[2] = itemstack.func_77946_l();
            } else if (this.slots[2].func_77973_b() == itemstack.func_77973_b()) {
                this.slots[2].field_77994_a += itemstack.field_77994_a;
            }
        }
        --this.slots[0].field_77994_a;
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
    }

    public int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 8000 / NuclearCraft.metalFurnaceCookEfficiency;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
            }
            if (block == Blocks.field_150402_ci) {
                return 960000 / NuclearCraft.metalFurnaceCookEfficiency;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 16000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151055_y) {
            return 4000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151044_h) {
            return 96000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151129_at) {
            return 1200000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 4000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        if (item == Items.field_151072_bj) {
            return 144000 / NuclearCraft.metalFurnaceCookEfficiency;
        }
        return GameRegistry.getFuelValue((ItemStack)itemstack) * 64 / NuclearCraft.metalFurnaceCookEfficiency;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1) {
            return this.getItemBurnTime(itemstack) > 0;
        }
        return slot == 0;
    }

    public int[] func_94128_d(int var1) {
        return var1 == 0 ? slots_bottom : (var1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = (int)this.furnaceSpeed;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int i) {
        return this.cookTime * i / (int)this.furnaceSpeed;
    }
}

