/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.Handlers;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;

@Handlers.Handler(getInstFrom=Handlers.Handler.Inst.METHOD)
public class Scheduler {
    private final Queue<ITask> clientQueue;
    private final Queue<ITask> serverQueue = new ConcurrentLinkedQueue<ITask>();

    public Scheduler(boolean isServer) {
        this.clientQueue = isServer ? null : new ConcurrentLinkedQueue<ITask>();
    }

    public void schedule(int delay, Runnable task) {
        this.schedule(delay, task, Side.SERVER);
    }

    public void schedule(int delay, Runnable task, Side side) {
        this.schedule(new Task(delay, task), side);
    }

    public void schedule(ITask task, Side side) {
        if (side == Side.SERVER) {
            this.serverQueue.add(task);
        } else if (this.clientQueue != null) {
            this.clientQueue.add(task);
        }
    }

    public static Scheduler instance() {
        return EnderCore.proxy.getScheduler();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runTasks(this.serverQueue);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runTasks(this.clientQueue);
            if (!this.serverQueue.isEmpty() && !Minecraft.func_71410_x().func_71387_A()) {
                this.serverQueue.clear();
            }
        }
    }

    private void runTasks(Queue<ITask> queue) {
        if (!queue.isEmpty()) {
            ArrayList<ITask> newtasks = new ArrayList<ITask>(queue.size());
            while (!queue.isEmpty()) {
                ITask task = queue.poll();
                if (task == null || (task = task.run()) == null) continue;
                newtasks.add(task);
            }
            for (ITask task : newtasks) {
                queue.add(task);
            }
        }
    }

    private static final class Task
    implements ITask {
        private int delay;
        private Runnable toRun;

        private Task(int delay, Runnable toRun) {
            this.delay = delay;
            this.toRun = toRun;
        }

        @Override
        public ITask run() {
            if (this.delay <= 0) {
                this.toRun.run();
                return null;
            }
            --this.delay;
            return this;
        }
    }

    public static interface ITask {
        public ITask run();
    }
}

