/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCharger
extends AENetworkPowerTile
implements ICrankable {
    final int[] sides = new int[]{0};
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    int tickTickTimer = 0;
    int lastUpdate = 0;
    boolean requiresUpdate = false;

    public TileCharger() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.gridProxy.setFlags(new GridFlags[0]);
        this.internalMaxPower = 1500.0;
        this.gridProxy.setIdlePowerUsage(0.0);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileCharger(ByteBuf data) {
        try {
            IAEItemStack item = AEItemStack.loadItemStackFromPacket(data);
            ItemStack is = item.getItemStack();
            this.inv.func_70299_a(0, is);
        }
        catch (Throwable t) {
            this.inv.func_70299_a(0, null);
        }
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileCharger(ByteBuf data) throws IOException {
        AEItemStack is = AEItemStack.create(this.func_70301_a(0));
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileCharger() {
        if (this.lastUpdate > 60 && this.requiresUpdate) {
            this.requiresUpdate = false;
            this.markForUpdate();
            this.lastUpdate = 0;
        }
        ++this.lastUpdate;
        ++this.tickTickTimer;
        if (this.tickTickTimer < 20) {
            return;
        }
        this.tickTickTimer = 0;
        ItemStack myItem = this.func_70301_a(0);
        if (this.internalCurrentPower < 1499.0) {
            try {
                this.injectExternalPower(PowerUnits.AE, this.gridProxy.getEnergy().extractAEPower(Math.min(150.0, 1500.0 - this.internalCurrentPower), Actionable.MODULATE, PowerMultiplier.ONE));
                this.tickTickTimer = 20;
            }
            catch (GridAccessException e) {
                // empty catch block
            }
        }
        if (myItem == null) {
            return;
        }
        IMaterials materials = AEApi.instance().definitions().materials();
        if (this.internalCurrentPower > 149.0 && Platform.isChargeable(myItem)) {
            IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.func_77973_b();
            if (ps.getAEMaxPower(myItem) > ps.getAECurrentPower(myItem)) {
                double oldPower = this.internalCurrentPower;
                double adjustment = ps.injectAEPower(myItem, this.extractAEPower(150.0, Actionable.MODULATE, PowerMultiplier.CONFIG));
                this.internalCurrentPower += adjustment;
                if (oldPower > this.internalCurrentPower) {
                    this.requiresUpdate = true;
                }
                this.tickTickTimer = 20;
            }
        } else if (this.internalCurrentPower > 1499.0 && materials.certusQuartzCrystal().isSameAs(myItem) && Platform.getRandomFloat() > 0.8f) {
            this.extractAEPower(this.internalMaxPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
            for (ItemStack charged : materials.certusQuartzCrystalCharged().maybeStack(myItem.field_77994_a).asSet()) {
                this.func_70299_a(0, charged);
            }
        }
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.gridProxy.setValidSides(EnumSet.of(this.getUp(), this.getUp().getOpposite()));
        this.setPowerSides(EnumSet.of(this.getUp(), this.getUp().getOpposite()));
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    @Override
    public boolean canTurn() {
        return this.internalCurrentPower < this.internalMaxPower;
    }

    @Override
    public void applyTurn() {
        IMaterials materials;
        this.injectExternalPower(PowerUnits.AE, 150.0);
        ItemStack myItem = this.func_70301_a(0);
        if (this.internalCurrentPower > 1499.0 && (materials = AEApi.instance().definitions().materials()).certusQuartzCrystal().isSameAs(myItem)) {
            this.extractAEPower(this.internalMaxPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
            for (ItemStack charged : materials.certusQuartzCrystalCharged().maybeStack(myItem.field_77994_a).asSet()) {
                this.func_70299_a(0, charged);
            }
        }
    }

    @Override
    public boolean canCrankAttach(ForgeDirection directionToCrank) {
        return this.getUp() == directionToCrank || this.getUp().getOpposite() == directionToCrank;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        IItemDefinition cert = AEApi.instance().definitions().materials().certusQuartzCrystal();
        return Platform.isChargeable(itemstack) || cert.isSameAs(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.markForUpdate();
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        IAEItemPowerStorage ips;
        if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.func_77973_b()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
            return true;
        }
        return AEApi.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(extractedItem);
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return this.sides;
    }

    public void activate(EntityPlayer player) {
        if (!Platform.hasPermissions(new DimensionalCoord(this), player)) {
            return;
        }
        ItemStack myItem = this.func_70301_a(0);
        if (myItem == null) {
            ItemStack held = player.field_71071_by.func_70448_g();
            if (AEApi.instance().definitions().materials().certusQuartzCrystal().isSameAs(held) || Platform.isChargeable(held)) {
                held = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                this.func_70299_a(0, held);
            }
        } else {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(myItem);
            this.func_70299_a(0, null);
            Platform.spawnDrops(this.field_145850_b, this.field_145851_c + this.getForward().offsetX, this.field_145848_d + this.getForward().offsetY, this.field_145849_e + this.getForward().offsetZ, drops);
        }
    }
}

