/*
 * Decompiled with CFR 0.152.
 */
package extracells.gridblock;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import extracells.api.IECTileEntity;
import extracells.tileentity.IListenerTile;
import extracells.tileentity.TileEntityFluidFiller;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ECFluidGridBlock
implements IGridBlock {
    protected IGrid grid;
    protected int usedChannels;
    protected IECTileEntity host;

    public ECFluidGridBlock(IECTileEntity _host) {
        this.host = _host;
    }

    public final EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.of(ForgeDirection.DOWN, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST});
    }

    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    public final AEColor getGridColor() {
        return AEColor.Transparent;
    }

    public double getIdlePowerUsage() {
        return this.host.getPowerUsage();
    }

    public final DimensionalCoord getLocation() {
        return this.host.getLocation();
    }

    public IGridHost getMachine() {
        return this.host;
    }

    public ItemStack getMachineRepresentation() {
        DimensionalCoord loc = this.getLocation();
        if (loc == null) {
            return null;
        }
        return new ItemStack(loc.getWorld().func_147439_a(loc.x, loc.y, loc.z), 1, loc.getWorld().func_72805_g(loc.x, loc.y, loc.z));
    }

    public void gridChanged() {
    }

    public final boolean isWorldAccessible() {
        return true;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public final void setNetworkStatus(IGrid _grid, int _usedChannels) {
        if (this.grid != null && this.host instanceof IListenerTile && this.grid != _grid) {
            ((IListenerTile)((Object)this.host)).updateGrid(this.grid, _grid);
            this.grid = _grid;
            this.usedChannels = _usedChannels;
            if (this.host instanceof TileEntityFluidFiller && this.grid.getCache(IStorageGrid.class) != null) {
                ((TileEntityFluidFiller)this.host).postChange((IBaseMonitor<IAEFluidStack>)((IStorageGrid)this.grid.getCache(IStorageGrid.class)).getFluidInventory(), null, null);
            }
        } else {
            this.grid = _grid;
            this.usedChannels = _usedChannels;
        }
    }
}

