/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import neresources.api.utils.DropItem;
import neresources.config.Settings;
import neresources.entries.MobEntry;
import neresources.gui.GuiContainerHook;
import neresources.reference.Resources;
import neresources.registry.MobRegistry;
import neresources.utils.Font;
import neresources.utils.MobHelper;
import neresources.utils.ModList;
import neresources.utils.RenderHelper;
import neresources.utils.TranslationHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import org.lwjgl.opengl.GL11;
import thaumcraft.common.entities.monster.EntityTaintacle;

public class NEIMobHandler
extends TemplateRecipeHandler {
    private static final int X_FIRST_ITEM = 90;
    private static final int Y_FIRST_ITEM = 42;
    private static int SPACING_Y = 90 / Settings.ITEMS_PER_COLUMN;
    private static int CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    private static int lastRecipe = -1;

    public static void reloadSettings() {
        SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
        CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    }

    public String getGuiTexture() {
        return Resources.Gui.Nei.MOB.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.mob.title");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(62, 72, 28, 18), "neresources.mob", new Object[]{new Object()}));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient.func_77973_b() instanceof ItemSword) {
            for (MobEntry entry : MobRegistry.getInstance().getMobs()) {
                this.arecipes.add(new CachedMob(entry));
            }
            lastRecipe = -1;
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("neresources.mob")) {
            for (MobEntry entry : MobRegistry.getInstance().getMobs()) {
                this.arecipes.add(new CachedMob(entry));
            }
            lastRecipe = -1;
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MobEntry entry : MobRegistry.getInstance().getMobsThatDropItem(result)) {
            this.arecipes.add(new CachedMob(entry));
        }
        lastRecipe = -1;
    }

    public void drawBackground(int recipe) {
        float offsetX;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)130);
        EntityLivingBase entityLivingBase = ((CachedMob)((Object)this.arecipes.get(recipe))).getMob();
        boolean normal = entityLivingBase.field_70130_N <= entityLivingBase.field_70131_O;
        float scale = this.getScale(entityLivingBase);
        float f = normal ? (scale > 34.0f ? 75.0f - scale / 2.0f : 75.0f - scale) : (offsetX = 72.0f);
        if (ModList.thaumcraft.isLoaded() && entityLivingBase instanceof EntityTaintacle) {
            offsetX = 115.0f;
        }
        RenderHelper.renderEntity(30, 165 - (int)offsetX, scale, 150 - GuiDraw.getMousePosition().x, 150 - GuiDraw.getMousePosition().y, entityLivingBase);
    }

    private float getScale(EntityLivingBase entityLivingBase) {
        float width = entityLivingBase.field_70130_N;
        float height = entityLivingBase.field_70131_O;
        if (width <= height) {
            if ((double)height < 0.8) {
                return 70.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 26.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    public void drawExtras(int recipe) {
        CachedMob cachedMob = (CachedMob)((Object)this.arecipes.get(recipe));
        Font.normal.print(cachedMob.mob.getMobName(), 2, 2);
        Font.normal.print(TranslationHelper.translateToLocal("ner.mob.biome"), 2, 12);
        Font.normal.print(cachedMob.mob.getLightLevel(), 2, 22);
        Font.normal.print(TranslationHelper.translateToLocal("ner.mob.exp") + ": " + MobHelper.getExpDrop(cachedMob.mob), 2, 32);
        int y = 46;
        for (int i = cachedMob.set * Settings.ITEMS_PER_COLUMN; i < cachedMob.set * Settings.ITEMS_PER_COLUMN + Settings.ITEMS_PER_COLUMN && i < cachedMob.mob.getDrops().length; ++i) {
            Font.normal.print(cachedMob.mob.getDrops()[i].toString(), 108, y);
            y += SPACING_Y;
        }
        if (cachedMob.lastSet > 0) {
            Font.normal.print(TranslationHelper.getLocalPageInfo(cachedMob.set, cachedMob.lastSet), 90, 120);
        }
        cachedMob.cycleOutputs(this.cycleticks, recipe);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        if (this.isOnBiome(GuiDraw.getMousePosition(), gui, recipe)) {
            CachedMob cachedMob = (CachedMob)((Object)this.arecipes.get(recipe));
            Collections.addAll(currenttip, cachedMob.mob.getBiomes());
        }
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> toolTip, int recipe) {
        if (stack != null) {
            toolTip.addAll(((CachedMob)((Object)this.arecipes.get(recipe))).getToolTip(stack));
        }
        return toolTip;
    }

    private boolean isOnBiome(Point mousePosition, GuiRecipe gui, int recipe) {
        GuiContainerHook guiContainerHook = new GuiContainerHook((GuiContainer)gui, gui.field_146294_l, gui.field_146295_m);
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mousePosition.x - guiContainerHook.getGuiLeft() - offset.x, mousePosition.y - guiContainerHook.getGuiTop() - offset.y);
        return 2 <= relMouse.x && relMouse.x < 165 && 12 <= relMouse.y && relMouse.y < 22;
    }

    public class CachedMob
    extends TemplateRecipeHandler.CachedRecipe {
        public MobEntry mob;
        public int set;
        public int lastSet;
        private long cycleAt;

        public CachedMob(MobEntry mob) {
            super((TemplateRecipeHandler)NEIMobHandler.this);
            this.mob = mob;
            this.set = 0;
            this.lastSet = mob.getDrops().length / (Settings.ITEMS_PER_COLUMN + 1);
            this.cycleAt = -1L;
        }

        public EntityLivingBase getMob() {
            return this.mob.getEntity();
        }

        public PositionedStack getResult() {
            if (this.mob.getDrops().length == 0) {
                return null;
            }
            return new PositionedStack((Object)this.mob.getDrops()[this.set * Settings.ITEMS_PER_COLUMN].item, 90, 42);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            int y = 42;
            for (int i = this.set * Settings.ITEMS_PER_COLUMN; i < this.set * Settings.ITEMS_PER_COLUMN + Settings.ITEMS_PER_COLUMN && i < this.mob.getDrops().length; ++i) {
                list.add(new PositionedStack((Object)this.mob.getDrops()[i].item, 90, y));
                y += SPACING_Y;
            }
            if (list.size() > 0) {
                list.remove(0);
            }
            return list;
        }

        public void cycleOutputs(long tick, int recipe) {
            if (this.cycleAt == -1L || recipe != lastRecipe) {
                lastRecipe = recipe;
                this.cycleAt = tick + (long)CYCLE_TIME;
                return;
            }
            if (tick >= this.cycleAt) {
                if (++this.set > this.lastSet) {
                    this.set = 0;
                }
                this.cycleAt += (long)CYCLE_TIME;
            }
        }

        public List<String> getToolTip(ItemStack stack) {
            for (DropItem item : this.mob.getDrops()) {
                if (!item.item.func_77969_a(stack)) continue;
                return item.conditionals;
            }
            return new ArrayList<String>();
        }
    }
}

