/*
 * Decompiled with CFR 0.152.
 */
package neresources.utils;

import cpw.mods.fml.common.Loader;
import neresources.compatibility.CompatBase;
import neresources.compatibility.appliedenergistics2.AE2Compat;
import neresources.compatibility.bigreactors.BigReactorsCompat;
import neresources.compatibility.bluepower.BluePowerCompat;
import neresources.compatibility.cofh.CoFHCompat;
import neresources.compatibility.forestry.ForestryCompat;
import neresources.compatibility.ic2.IC2Compat;
import neresources.compatibility.metallurgy.MetallurgyCompat;
import neresources.compatibility.minecraft.MinecraftCompat;
import neresources.compatibility.mobproperties.MobPropertiesCompat;
import neresources.compatibility.netherores.NetherOresCompat;
import neresources.compatibility.reika.ElectriCraftCompat;
import neresources.compatibility.reika.ReactorCraftCompat;
import neresources.compatibility.reliquary.ReliquaryCompat;
import neresources.compatibility.thaumcraft.ThaumcraftCompat;
import neresources.compatibility.tinkersconstruct.TiConCompat;

public enum ModList {
    minecraft(MinecraftCompat.class),
    cofhcore("CoFHCore", CoFHCompat.class),
    metallurgy("Metallurgy", MetallurgyCompat.class),
    netherores("NetherOres", NetherOresCompat.class),
    bigreactors("BigReactors", BigReactorsCompat.class),
    ae2("appliedenergistics2", AE2Compat.class),
    thaumcraft("Thaumcraft", ThaumcraftCompat.class),
    electricraft("ElectriCraft", ElectriCraftCompat.class),
    reactorcraft("ReactorCraft", ReactorCraftCompat.class),
    forestry("Forestry", ForestryCompat.class),
    ticon("TConstruct", TiConCompat.class),
    denseores("denseores"),
    mystcraft("Mystcraft"),
    ic2("IC2", IC2Compat.class),
    mobproperties("MobProperties", MobPropertiesCompat.class),
    reliquary("xreliquary", ReliquaryCompat.class),
    bluepower("bluepower", BluePowerCompat.class);

    private String name;
    private Class compat;
    private boolean isLoaded;

    private ModList(Class compat) {
        this.name = "minecraft";
        this.compat = compat;
        this.isLoaded = true;
    }

    private ModList(String name) {
        this(name, null);
    }

    private ModList(String name, Class compat) {
        this.name = name;
        this.compat = compat;
        this.isLoaded = Loader.isModLoaded((String)this.name);
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public Class compatClass() {
        return this.compat;
    }

    public String toString() {
        return this.name;
    }

    public boolean initialise() {
        return this.compat != null && CompatBase.load(this);
    }

    public class Names {
        public static final String COFHCORE = "CoFHCore";
        public static final String METALLURGY = "Metallurgy";
        public static final String APPLIEDENERGISTICS = "appliedenergistics2";
        public static final String BIGREACTORS = "BigReactors";
        public static final String FORESTRY = "Forestry";
        public static final String NETHERORES = "NetherOres";
        public static final String ELECTRICRAFT = "ElectriCraft";
        public static final String REACTORCRAFT = "ReactorCraft";
        public static final String THAUMCRAFT = "Thaumcraft";
        public static final String TICON = "TConstruct";
        public static final String DENSEORES = "denseores";
        public static final String MYSTCRAFT = "Mystcraft";
        public static final String IC2 = "IC2";
        public static final String MOBPROPERTIES = "MobProperties";
        public static final String RELIQUARY = "xreliquary";
        public static final String BLUEPOWER = "bluepower";
    }
}

