/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import openmods.calc.BinaryOperator;
import openmods.calc.UnaryOperator;
import openmods.calc.parsing.DefaultExprNodeFactory;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.TokenUtils;
import openmods.utils.CollectionUtils;

public class MappedExprNodeFactory<E>
extends DefaultExprNodeFactory<E> {
    private final Map<String, IBracketExprNodeFactory<E>> bracketFactories = Maps.newHashMap();
    private final Map<BinaryOperator<E>, IBinaryExprNodeFactory<E>> binaryOpFactories = Maps.newIdentityHashMap();
    private final Map<UnaryOperator<E>, IUnaryExprNodeFactory<E>> unaryOpFactories = Maps.newIdentityHashMap();

    public MappedExprNodeFactory(IValueParser<E> valueParser) {
        super(valueParser);
    }

    @Override
    public IExprNode<E> createBracketNode(String openingBracket, String closingBracket, List<IExprNode<E>> children) {
        TokenUtils.checkIsValidBracketPair(openingBracket, closingBracket);
        IBracketExprNodeFactory<E> nodeFactory = this.bracketFactories.get(openingBracket);
        return nodeFactory != null ? nodeFactory.create(children) : this.createDefaultBracketNode(openingBracket, closingBracket, children);
    }

    protected IExprNode<E> createDefaultBracketNode(String openingBracket, String closingBracket, List<IExprNode<E>> children) {
        return super.createBracketNode(openingBracket, closingBracket, children);
    }

    @Override
    public IExprNode<E> createBinaryOpNode(BinaryOperator<E> op, IExprNode<E> leftChild, IExprNode<E> rightChild) {
        IBinaryExprNodeFactory<E> nodeFactory = this.binaryOpFactories.get(op);
        return nodeFactory != null ? nodeFactory.create(leftChild, rightChild) : this.createDefaultBinaryOpNode(op, leftChild, rightChild);
    }

    protected IExprNode<E> createDefaultBinaryOpNode(BinaryOperator<E> op, IExprNode<E> leftChild, IExprNode<E> rightChild) {
        return super.createBinaryOpNode(op, leftChild, rightChild);
    }

    @Override
    public IExprNode<E> createUnaryOpNode(UnaryOperator<E> op, IExprNode<E> child) {
        IUnaryExprNodeFactory<E> nodeFactory = this.unaryOpFactories.get(op);
        return nodeFactory != null ? nodeFactory.create(child) : this.createDefaultUnaryOpNode(op, child);
    }

    protected IExprNode<E> createDefaultUnaryOpNode(UnaryOperator<E> op, IExprNode<E> child) {
        return super.createUnaryOpNode(op, child);
    }

    public MappedExprNodeFactory<E> addFactory(String openingBracket, IBracketExprNodeFactory<E> factory) {
        CollectionUtils.putOnce(this.bracketFactories, openingBracket, factory);
        return this;
    }

    public MappedExprNodeFactory<E> addFactory(BinaryOperator<E> op, IBinaryExprNodeFactory<E> factory) {
        CollectionUtils.putOnce(this.binaryOpFactories, op, factory);
        return this;
    }

    public MappedExprNodeFactory<E> addFactory(UnaryOperator<E> op, IUnaryExprNodeFactory<E> factory) {
        CollectionUtils.putOnce(this.unaryOpFactories, op, factory);
        return this;
    }

    public static interface IUnaryExprNodeFactory<E> {
        public IExprNode<E> create(IExprNode<E> var1);
    }

    public static interface IBinaryExprNodeFactory<E> {
        public IExprNode<E> create(IExprNode<E> var1, IExprNode<E> var2);
    }

    public static interface IBracketExprNodeFactory<E> {
        public IExprNode<E> create(List<IExprNode<E>> var1);
    }
}

