/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ModIdentifier {
    public static final ModIdentifier INSTANCE = new ModIdentifier();
    private final Map<Item, ModContainer> itemCache = Maps.newHashMap();
    private final Map<Block, ModContainer> blockCache = Maps.newHashMap();

    public ModContainer getModItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        return this.getModForItem(item);
    }

    public ModContainer getModForItem(Item item) {
        if (this.itemCache.containsKey(item)) {
            return this.itemCache.get(item);
        }
        ModContainer result = this.identifyItem(item);
        this.itemCache.put(item, result);
        return result;
    }

    public ModContainer getModForBlock(Block block) {
        if (this.blockCache.containsKey(block)) {
            return this.blockCache.get(block);
        }
        ModContainer result = ModIdentifier.identifyBlock(block);
        this.blockCache.put(block, result);
        return result;
    }

    private static ModContainer identifyBlock(Block block) {
        return ModIdentifier.findModContainer(GameRegistry.findUniqueIdentifierFor((Block)block));
    }

    private ModContainer identifyItem(Item item) {
        if (item instanceof ItemBlock) {
            return this.getModForBlock(((ItemBlock)item).field_150939_a);
        }
        return ModIdentifier.findModContainer(GameRegistry.findUniqueIdentifierFor((Item)item));
    }

    private static ModContainer findModContainer(GameRegistry.UniqueIdentifier id) {
        if (id == null) {
            return null;
        }
        String modId = id.modId;
        return (ModContainer)Loader.instance().getIndexedModList().get(modId);
    }
}

