/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipeCrusher;
import com.cout970.magneticraft.api.access.RecipeGrinder;
import com.cout970.magneticraft.api.access.RecipeSifter;
import java.util.List;
import java.util.stream.Collectors;
import wanion.unidict.UniDict;
import wanion.unidict.common.FixedSizeList;
import wanion.unidict.integration.AbstractIntegrationThread;

final class MagneticraftIntegration
extends AbstractIntegrationThread {
    MagneticraftIntegration() {
        super("Magneticraft");
    }

    @Override
    public String call() {
        try {
            this.fixCrusherRecipes();
            this.fixGrinderRecipes();
            this.fixSifterRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The world's magnetic poles appear to be inverting.";
    }

    private void fixCrusherRecipes() {
        List crusherRecipeList = MgRecipeRegister.crusher;
        FixedSizeList newRecipes = new FixedSizeList(crusherRecipeList.size());
        newRecipes.addAll(crusherRecipeList.stream().map(crusherRecipe -> new RecipeCrusher(this.resourceHandler.getMainItemStack(crusherRecipe.getInput()), this.resourceHandler.getMainItemStack(crusherRecipe.getOutput()), this.resourceHandler.getMainItemStack(crusherRecipe.getOutput2()), crusherRecipe.getProb2(), this.resourceHandler.getMainItemStack(crusherRecipe.getOutput3()), crusherRecipe.getProb3())).collect(Collectors.toList()));
        crusherRecipeList.clear();
        crusherRecipeList.addAll(newRecipes);
    }

    private void fixGrinderRecipes() {
        List grinderRecipeList = MgRecipeRegister.grinder;
        FixedSizeList newRecipes = new FixedSizeList(grinderRecipeList.size());
        newRecipes.addAll(grinderRecipeList.stream().map(grinderRecipe -> new RecipeGrinder(this.resourceHandler.getMainItemStack(grinderRecipe.getInput()), this.resourceHandler.getMainItemStack(grinderRecipe.getOutput()), this.resourceHandler.getMainItemStack(grinderRecipe.getOutput2()), grinderRecipe.getProb2(), this.resourceHandler.getMainItemStack(grinderRecipe.getOutput3()), grinderRecipe.getProb3())).collect(Collectors.toList()));
        grinderRecipeList.clear();
        grinderRecipeList.addAll(newRecipes);
    }

    private void fixSifterRecipes() {
        List sifterRecipeList = MgRecipeRegister.sifter;
        FixedSizeList newRecipes = new FixedSizeList(sifterRecipeList.size());
        newRecipes.addAll(sifterRecipeList.stream().map(sifterRecipe -> new RecipeSifter(this.resourceHandler.getMainItemStack(sifterRecipe.getInput()), this.resourceHandler.getMainItemStack(sifterRecipe.getOutput()), this.resourceHandler.getMainItemStack(sifterRecipe.getExtra()), sifterRecipe.getProb())).collect(Collectors.toList()));
        sifterRecipeList.clear();
        sifterRecipeList.addAll(newRecipes);
    }
}

