/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cofh.thermalexpansion.util.crafting.PulverizerManager;
import cofh.thermalexpansion.util.crafting.SmelterManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import wanion.unidict.LoadStage;
import wanion.unidict.UniDict;
import wanion.unidict.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.module.SpecifiedLoadStage;

@SpecifiedLoadStage(stage=LoadStage.LOAD_COMPLETE)
final class TEIntegration
extends AbstractIntegrationThread {
    TEIntegration() {
        super("Thermal Expansion");
    }

    @Override
    public String call() {
        try {
            this.fixRedstoneFurnaceRecipes();
            this.fixPulverizerRecipes();
            this.fixInductionSmelterRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The world seems to be more thermally involved.";
    }

    private void fixRedstoneFurnaceRecipes() {
        Map recipeMap = (Map)Util.getField(FurnaceManager.class, "recipeMap", null, Map.class);
        if (recipeMap == null) {
            return;
        }
        Constructor redstoneFurnaceRecipeConstructor = null;
        try {
            redstoneFurnaceRecipeConstructor = FurnaceManager.RecipeFurnace.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, Integer.TYPE);
            redstoneFurnaceRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (redstoneFurnaceRecipeConstructor == null) {
            return;
        }
        for (FurnaceManager.ComparableItemStackFurnace recipeMapKey : recipeMap.keySet()) {
            FurnaceManager.RecipeFurnace redstoneFurnaceRecipe = (FurnaceManager.RecipeFurnace)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(redstoneFurnaceRecipe.getOutput());
            if (correctOutput == redstoneFurnaceRecipe.getOutput()) continue;
            try {
                recipeMap.put(recipeMapKey, redstoneFurnaceRecipeConstructor.newInstance(redstoneFurnaceRecipe.getInput(), correctOutput, redstoneFurnaceRecipe.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixPulverizerRecipes() {
        Map recipeMap = (Map)Util.getField(PulverizerManager.class, "recipeMap", null, Map.class);
        if (recipeMap == null) {
            return;
        }
        Constructor pulverizerRecipeConstructor = null;
        try {
            pulverizerRecipeConstructor = PulverizerManager.RecipePulverizer.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE);
            pulverizerRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (pulverizerRecipeConstructor == null) {
            return;
        }
        for (PulverizerManager.ComparableItemStackPulverizer recipeMapKey : recipeMap.keySet()) {
            PulverizerManager.RecipePulverizer pulverizerRecipe = (PulverizerManager.RecipePulverizer)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(pulverizerRecipe.getPrimaryOutput());
            ItemStack correctSecondaryOutput = this.resourceHandler.getMainItemStack(pulverizerRecipe.getSecondaryOutput());
            if (correctOutput == pulverizerRecipe.getPrimaryOutput() && correctSecondaryOutput == pulverizerRecipe.getSecondaryOutput()) continue;
            try {
                recipeMap.put(recipeMapKey, pulverizerRecipeConstructor.newInstance(pulverizerRecipe.getInput(), correctOutput, correctSecondaryOutput, pulverizerRecipe.getSecondaryOutputChance(), pulverizerRecipe.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void fixInductionSmelterRecipes() {
        Map recipeMap = (Map)Util.getField(SmelterManager.class, "recipeMap", null, Map.class);
        if (recipeMap == null) {
            return;
        }
        Constructor smelterRecipeConstructor = null;
        try {
            smelterRecipeConstructor = SmelterManager.RecipeSmelter.class.getDeclaredConstructor(ItemStack.class, ItemStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE);
            smelterRecipeConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (smelterRecipeConstructor == null) {
            return;
        }
        for (List recipeMapKey : recipeMap.keySet()) {
            SmelterManager.RecipeSmelter smelterRecipe = (SmelterManager.RecipeSmelter)recipeMap.get(recipeMapKey);
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(smelterRecipe.getPrimaryOutput());
            ItemStack correctSecondaryOutput = this.resourceHandler.getMainItemStack(smelterRecipe.getSecondaryOutput());
            if (correctOutput == smelterRecipe.getPrimaryOutput() && correctSecondaryOutput == smelterRecipe.getSecondaryOutput()) continue;
            try {
                recipeMap.put(recipeMapKey, smelterRecipeConstructor.newInstance(smelterRecipe.getPrimaryInput(), smelterRecipe.getSecondaryInput(), correctOutput, correctSecondaryOutput, smelterRecipe.getSecondaryOutputChance(), smelterRecipe.getEnergy()));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

