/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import lain.mods.cos.CosmeticArmorReworked;
import lain.mods.cos.inventory.InventoryCosArmor;
import lain.mods.cos.network.packet.PacketSyncCosArmor;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class InventoryManager {
    LoadingCache<UUID, InventoryCosArmor> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<UUID, InventoryCosArmor>(){

        public InventoryCosArmor load(UUID owner) throws Exception {
            InventoryCosArmor inv = new InventoryCosArmor();
            try {
                InventoryManager.this.forceLoad(owner, inv);
            }
            catch (IOException e) {
                System.err.println("Error loading CosmeticArmor data file: " + e.getMessage());
                e.printStackTrace();
                inv = new InventoryCosArmor();
            }
            inv.func_70296_d();
            return inv;
        }
    });

    void forceLoad(UUID uuid, InventoryCosArmor inv) throws IOException {
        try {
            inv.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(this.getDataFile(uuid))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    void forceSave(UUID uuid, InventoryCosArmor inv) throws IOException {
        NBTTagCompound compound = new NBTTagCompound();
        inv.writeToNBT(compound);
        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(this.getDataFile(uuid)));
    }

    public InventoryCosArmor getCosArmorInventory(UUID uuid) {
        return (InventoryCosArmor)this.cache.getUnchecked((Object)uuid);
    }

    public InventoryCosArmor getCosArmorInventoryClient(UUID uuid) {
        throw new UnsupportedOperationException();
    }

    File getDataFile(UUID uuid) {
        return new File(new File(this.getSavesDirectory(), "playerdata"), uuid + ".cosarmor");
    }

    File getSavesDirectory() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return new File(server.func_71209_f("saves"), server.func_71218_a(0).func_72860_G().func_75760_g());
        }
        return server.func_71209_f(server.func_71270_I());
    }

    @SubscribeEvent
    public void handleEvent(PlayerDropsEvent event) {
        if (event.entityPlayer instanceof EntityPlayerMP && !event.entityPlayer.field_70170_p.field_72995_K && !event.entityPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            InventoryCosArmor inv = this.getCosArmorInventory(event.entityPlayer.func_110124_au());
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                EntityItem ent = new EntityItem(event.entityPlayer.field_70170_p, event.entityPlayer.field_70165_t, event.entityPlayer.field_70163_u + (double)event.entityPlayer.func_70047_e(), event.entityPlayer.field_70161_v, stack.func_77946_l());
                ent.field_145804_b = 40;
                float f1 = event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * 0.5f;
                float f2 = event.entityPlayer.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                ent.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
                ent.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
                ent.field_70181_x = 0.2f;
                event.drops.add(ent);
                inv.func_70299_a(i, null);
                inv.func_70296_d();
            }
        }
    }

    @SubscribeEvent
    public void handleEvent(PlayerEvent.LoadFromFile event) {
        UUID uuid = UUID.fromString(event.playerUUID);
        InventoryCosArmor inv = this.getCosArmorInventory(uuid);
        try {
            inv.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(this.getDataFile(uuid))));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            System.err.println("Error loading CosmeticArmor data file: " + e.getMessage());
            e.printStackTrace();
            this.cache.refresh((Object)uuid);
            inv = this.getCosArmorInventory(uuid);
        }
        inv.func_70296_d();
    }

    @SubscribeEvent
    public void handleEvent(PlayerEvent.SaveToFile event) {
        UUID uuid = UUID.fromString(event.playerUUID);
        InventoryCosArmor inv = this.getCosArmorInventory(uuid);
        NBTTagCompound compound = new NBTTagCompound();
        inv.writeToNBT(compound);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(this.getDataFile(uuid)));
        }
        catch (IOException e) {
            System.err.println("Error saving CosmeticArmor data file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void handleEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            InventoryCosArmor inv = this.getCosArmorInventory(event.player.func_110124_au());
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                CosmeticArmorReworked.network.sendToAll(new PacketSyncCosArmor(event.player, i));
            }
            inv.markClean();
            for (EntityPlayerMP other : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
                if (other == event.player) continue;
                inv = this.getCosArmorInventory(other.func_110124_au());
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    CosmeticArmorReworked.network.sendTo(new PacketSyncCosArmor((EntityPlayer)other, i), (EntityPlayerMP)event.player);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            UUID uuid = event.player.func_110124_au();
            try {
                this.forceSave(uuid, this.getCosArmorInventory(uuid));
            }
            catch (IOException e) {
                System.err.println("Error saving CosmeticArmor data file: " + e.getMessage());
                e.printStackTrace();
            }
            this.cache.invalidate((Object)uuid);
        }
    }

    @SubscribeEvent
    public void handleEvent(TickEvent.PlayerTickEvent event) {
        InventoryCosArmor inv;
        if (event.phase == TickEvent.Phase.START && event.player instanceof EntityPlayerMP && (inv = this.getCosArmorInventory(event.player.func_110124_au())).isDirty()) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                CosmeticArmorReworked.network.sendToAll(new PacketSyncCosArmor(event.player, i));
            }
            inv.markClean();
        }
    }

    void onServerStarting() {
        this.cache.invalidateAll();
    }

    void onServerStopping() {
        System.out.println("Server is stopping... force saving all loaded CosmeticArmor data.");
        for (UUID uuid : this.cache.asMap().keySet()) {
            System.out.println(uuid);
            try {
                this.forceSave(uuid, this.getCosArmorInventory(uuid));
            }
            catch (IOException e) {
                System.err.println("Error saving CosmeticArmor data file: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

