/*
 * Decompiled with CFR 0.152.
 */
package panda.birdsnests;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import panda.birdsnests.DecayLeafEventHandler;
import panda.birdsnests.HarvestLeafEventHandler;
import panda.birdsnests.ItemNest;
import panda.birdsnests.OnJoinWorldHandler;
import panda.birdsnests.VersionChecker;
import panda.birdsnests.dropRegistry;

@Mod(modid="birdsnests", name="Bird's Nests", version="1.4")
public class BirdsNests {
    public static final String MODID = "birdsnests";
    public static final String NAME = "Bird's Nests";
    public static final String VERSION = "1.4";
    public static int RARITY_MULTIPLIER = 1;
    public static int nestRarity = 40;
    public static float decayDropModifier;
    public static boolean allowDecayDrops;
    public static final Item nest;
    public static VersionChecker versionChecker;
    public static boolean haveWarnedVersionOutOfDate;
    public static String[] mega;
    public static String dL;
    public static Logger log;
    @Mod.Instance(value="birdsnests")
    public static BirdsNests instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        nest.func_77655_b("birdsnest");
        GameRegistry.registerItem((Item)nest, (String)"birdsnest");
        MinecraftForge.EVENT_BUS.register((Object)new HarvestLeafEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DecayLeafEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OnJoinWorldHandler());
        log = LogManager.getLogger((String)NAME);
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        nestRarity = config.getInt("NEST_DROP_RARITY", "general", 24, 0, 1000, "");
        decayDropModifier = config.getFloat("NEST_DECAY_DROP_MULTIPLIER", "general", 1.25f, 0.0f, 1000.0f, "This makes nests more (or less ) rare from decaying leaves. Leave at 1 for no change.");
        allowDecayDrops = config.getBoolean("ALLOW_DECAY_DROPS", "general", true, "Allows to enable/disable nests dropping from decaying leaves");
        RARITY_MULTIPLIER = config.getInt("RARITY_MULTIPLIER", "general", 1, 0, 1000, "Multiplies rarity of all drops");
        dL = dL.concat("minecraft:stick,0,1-2-3-3;");
        dL = dL.concat("minecraft:feather,0,1-3;");
        dL = dL.concat("minecraft:egg,0,2;");
        dL = dL.concat("minecraft:string,0,4-4;");
        dL = dL.concat("minecraft:bone,0,6-16;");
        dL = dL.concat("minecraft:flint,0,4;");
        dL = dL.concat("minecraft:wheat_seeds,0,6-12;");
        dL = dL.concat("minecraft:melon_seeds,0,25;");
        dL = dL.concat("minecraft:pumpkin_seeds,0,25;");
        dL = dL.concat("minecraft:diamond,0,25;");
        dL = dL.concat("minecraft:emerald,0,30;");
        dL = dL.concat("minecraft:redstone,0,13-18;");
        dL = dL.concat("minecraft:glowstone_dust,0,6-12;");
        dL = dL.concat("minecraft:blaze_powder,0,40-40;");
        dL = dL.concat("minecraft:gold_nugget,0,8-10-13-16;");
        dL = dL.concat("minecraft:fish,0,30;");
        dL = dL.concat("exnihilo:silkworm,0,16-18;");
        dL = dL.concat("exnihilo:stone,0,4-6;");
        dL = dL.concat("exnihilo:seeds_potato,0,14;");
        dL = dL.concat("exnihilo:seeds_carrot,0,14;");
        dL = dL.concat("exnihilo:seeds_sugarcane,0,33;");
        dL = dL.concat("exnihilo:seeds_cactus,0,33;");
        dL = dL.concat("exnihilo:seeds_grass,0,33;");
        dL = dL.concat("exnihilo:spores,0,100;");
        dL = dL.concat("exnihilo:seed_oak,0,12;");
        dL = dL.concat("exnihilo:seed_spruce,0,25;");
        dL = dL.concat("exnihilo:seed_birch,0,25;");
        dL = dL.concat("exnihilo:seed_jungle,0,25;");
        dL = dL.concat("exnihilo:seed_acacia,0,25;");
        dL = dL.concat("exnihilo:seed_dark_oak,0,25;");
        System.out.println(dL.toString());
        config.addCustomCategoryComment("Drops", "Numbers can roughly be interpreted as 'one out of n' chance of dropping. \n Multiple numbers mean the drop will have that chance of dropping the first, second, third...etc item");
        mega = config.get("Drops", "List", dL, "Format 'ID,META,rarity1-rarity2-rarity3-rarityX' \n To add apples with rarity of '10,20' it would be 'minecraft:apple,0,10-20' \n Separate items using ';'").getString().split(";");
        config.save();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void PostInitialize(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            versionChecker = new VersionChecker();
            Thread versionCheckThread = new Thread((Runnable)versionChecker, "Nests Version Check");
            versionCheckThread.start();
        }
        if (mega != null && mega.length > 0 && mega[0].length() > 1) {
            for (int i = 0; i < mega.length; ++i) {
                String[] tempsplit = mega[i].split(",");
                if (tempsplit.length == 3) {
                    if ((Item)Item.field_150901_e.func_82594_a(tempsplit[0]) != null) {
                        dropRegistry.registerConfigRarity(tempsplit[2].split("-"), (Item)Item.field_150901_e.func_82594_a(tempsplit[0]), Integer.parseInt(tempsplit[1]));
                        log.info("Custom drop " + tempsplit[0] + " added");
                        continue;
                    }
                    log.error("UNABLE TO RESOLVE CUSTOM DROP " + tempsplit[0]);
                    continue;
                }
                log.error("UNABLE TO TRANSLATE CUSTOM DROP " + mega[i]);
            }
        }
    }

    static {
        allowDecayDrops = true;
        nest = new ItemNest();
        haveWarnedVersionOutOfDate = false;
        dL = "";
    }
}

