/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.item.IEqualityOverrideItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.TextureHelper;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.entity.FancyEntityItem;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.TinkerWeaponry;

@Optional.InterfaceList(value={@Optional.Interface(modid="CoFHAPI|energy", iface="cofh.api.energy.IEnergyContainerItem"), @Optional.Interface(modid="CoFHCore", iface="cofh.core.item.IEqualityOverrideItem")})
public abstract class ToolCore
extends Item
implements IEnergyContainerItem,
IEqualityOverrideItem,
IModifyable {
    protected Random random = new Random();
    protected int damageVsEntity;
    public static IIcon blankSprite;
    public static IIcon emptyIcon;
    public HashMap<Integer, IIcon> headIcons = new HashMap();
    public HashMap<Integer, IIcon> brokenIcons = new HashMap();
    public HashMap<Integer, IIcon> handleIcons = new HashMap();
    public HashMap<Integer, IIcon> accessoryIcons = new HashMap();
    public HashMap<Integer, IIcon> effectIcons = new HashMap();
    public HashMap<Integer, IIcon> extraIcons = new HashMap();
    public HashMap<Integer, String> headStrings = new HashMap();
    public HashMap<Integer, String> brokenPartStrings = new HashMap();
    public HashMap<Integer, String> handleStrings = new HashMap();
    public HashMap<Integer, String> accessoryStrings = new HashMap();
    public HashMap<Integer, String> effectStrings = new HashMap();
    public HashMap<Integer, String> extraStrings = new HashMap();
    protected int capacity = 400000;
    protected int maxReceive = 400000;
    protected int maxExtract = 80;

    public ToolCore(int baseDamage) {
        this.field_77777_bU = 1;
        this.func_77656_e(100);
        this.func_77655_b("InfiTool");
        this.func_77637_a(TConstructRegistry.toolTab);
        this.damageVsEntity = baseDamage;
        TConstructRegistry.addToolMapping(this);
        this.setNoRepair();
        this.canRepair = false;
    }

    @Override
    public String getBaseTagName() {
        return "InfiTool";
    }

    @Override
    public String getModifyType() {
        return "Tool";
    }

    public int durabilityTypeHandle() {
        return 1;
    }

    public int durabilityTypeAccessory() {
        return 0;
    }

    public int durabilityTypeExtra() {
        return 0;
    }

    public int getModifierAmount() {
        return 3;
    }

    public String getToolName() {
        return this.getClass().getSimpleName();
    }

    public String getLocalizedToolName() {
        return StatCollector.func_74838_a((String)("tool." + this.getToolName().toLowerCase()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final int getRenderPasses(int metadata) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public int getPartAmount() {
        return 3;
    }

    public abstract String getIconSuffix(int var1);

    public abstract String getEffectSuffix();

    public abstract String getDefaultFolder();

    public String getDefaultTexturePath() {
        return "tinker:" + this.getDefaultFolder();
    }

    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.brokenPartStrings.put(index, location[1]);
        this.handleStrings.put(index, location[2]);
        if (location.length > 3) {
            this.accessoryStrings.put(index, location[3]);
        }
        if (location.length > 4) {
            this.extraStrings.put(index, location[4]);
        }
    }

    public void registerAlternatePartPaths(int index, String[] location) {
    }

    public void registerEffectPath(int index, String location) {
        this.effectStrings.put(index, location);
    }

    public void func_94581_a(IIconRegister iconRegister) {
        boolean minimalTextures = PHConstruct.minimalTextures;
        this.addIcons(this.headStrings, this.headIcons, iconRegister, this.getIconSuffix(0), minimalTextures);
        this.addIcons(this.brokenPartStrings, this.brokenIcons, iconRegister, this.getIconSuffix(1), minimalTextures);
        this.addIcons(this.handleStrings, this.handleIcons, iconRegister, this.getIconSuffix(2), minimalTextures);
        this.addIcons(this.accessoryStrings, this.accessoryIcons, iconRegister, this.getIconSuffix(3), minimalTextures);
        this.addIcons(this.extraStrings, this.extraIcons, iconRegister, this.getIconSuffix(4), minimalTextures);
        this.addIcons(this.effectStrings, this.effectIcons, iconRegister, null, false);
        emptyIcon = iconRegister.func_94245_a("tinker:blankface");
    }

    protected void addIcons(HashMap<Integer, String> textures, HashMap<Integer, IIcon> icons, IIconRegister iconRegister, String standard, boolean defaultOnly) {
        icons.clear();
        if (!defaultOnly) {
            for (Map.Entry<Integer, String> entry : textures.entrySet()) {
                if (!TextureHelper.itemTextureExists(entry.getValue())) continue;
                icons.put(entry.getKey(), iconRegister.func_94245_a(entry.getValue()));
            }
        }
        if (standard != null && !standard.isEmpty()) {
            standard = this.getDefaultTexturePath() + "/" + standard;
            icons.put(-1, iconRegister.func_94245_a(standard));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return blankSprite;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            String effect;
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    return this.getCorrectIcon(this.handleIcons, tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    if (tags.func_74767_n("Broken")) {
                        return this.getCorrectIcon(this.brokenIcons, tags.func_74762_e("RenderHead"));
                    }
                    return this.getCorrectIcon(this.headIcons, tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return this.getCorrectIcon(this.accessoryIcons, tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return this.getCorrectIcon(this.extraIcons, tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass <= 10 && tags.func_74764_b(effect = "Effect" + (1 + renderPass - this.getPartAmount()))) {
                return this.effectIcons.get(tags.func_74762_e(effect));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    protected IIcon getCorrectIcon(Map<Integer, IIcon> icons, int id) {
        if (icons.containsKey(id)) {
            return icons.get(id);
        }
        return icons.get(-1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("Energy")) {
            String color = "";
            int RF = tags.func_74762_e("Energy");
            if (RF != 0) {
                color = RF <= this.getMaxEnergyStored(stack) / 3 ? "\u00a74" : (RF > this.getMaxEnergyStored(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String energy = color + tags.func_74762_e("Energy") + "/" + this.getMaxEnergyStored(stack) + " RF";
            list.add(energy);
        }
        if (tags.func_74764_b("InfiTool")) {
            boolean broken = tags.func_74775_l("InfiTool").func_74767_n("Broken");
            if (broken) {
                list.add("\u00a7o" + StatCollector.func_74838_a((String)"tool.core.broken"));
            } else {
                int unbreaking;
                String reinforced;
                String extraName;
                String bindingName;
                String handleName;
                int head = tags.func_74775_l("InfiTool").func_74762_e("Head");
                int handle = tags.func_74775_l("InfiTool").func_74762_e("Handle");
                int binding = tags.func_74775_l("InfiTool").func_74762_e("Accessory");
                int extra = tags.func_74775_l("InfiTool").func_74762_e("Extra");
                String headName = this.getAbilityNameForType(head, 0);
                if (!headName.equals("")) {
                    list.add(ToolCore.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getAbilityNameForType(handle, 1)).equals("") && handle != head) {
                    list.add(ToolCore.getStyleForType(handle) + handleName);
                }
                if (this.getPartAmount() >= 3 && !(bindingName = this.getAbilityNameForType(binding, 2)).equals("") && binding != head && binding != handle) {
                    list.add(ToolCore.getStyleForType(binding) + bindingName);
                }
                if (this.getPartAmount() >= 4 && !(extraName = this.getAbilityNameForType(extra, 3)).equals("") && extra != head && extra != handle && extra != binding) {
                    list.add(ToolCore.getStyleForType(extra) + extraName);
                }
                if (!(reinforced = this.getReinforcedName(head, handle, binding, extra, unbreaking = tags.func_74775_l("InfiTool").func_74762_e("Unbreaking"))).equals("")) {
                    list.add(reinforced);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.func_74775_l("InfiTool").func_74764_b(tooltip)) {
                        String tipName = tags.func_74775_l("InfiTool").func_74779_i(tooltip);
                        if (tipName.equals("")) continue;
                        String locString = "modifier.tooltip." + EnumChatFormatting.func_110646_a((String)tipName);
                        if (StatCollector.func_94522_b((String)(locString = locString.replace(" ", "")))) {
                            tipName = tipName.replace(EnumChatFormatting.func_110646_a((String)tipName), StatCollector.func_74838_a((String)locString));
                        }
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
        list.add("");
        int attack = (int)((float)tags.func_74775_l("InfiTool").func_74762_e("Attack") * this.getDamageModifier());
        list.add("\u00a79+" + attack + " " + StatCollector.func_74837_a((String)"attribute.name.generic.attackDamage", (Object[])new Object[0]));
    }

    public static String getStyleForType(int type) {
        return TConstructRegistry.getMaterial(type).style();
    }

    public String getAbilityNameForType(int type, int part) {
        return TConstructRegistry.getMaterial(type).ability();
    }

    public String getReinforcedName(int head, int handle, int accessory, int extra, int unbreaking) {
        ToolMaterial headMat = TConstructRegistry.getMaterial(head);
        ToolMaterial handleMat = TConstructRegistry.getMaterial(handle);
        ToolMaterial accessoryMat = TConstructRegistry.getMaterial(accessory);
        ToolMaterial extraMat = TConstructRegistry.getMaterial(extra);
        int reinforced = 0;
        String style = "";
        int current = headMat.reinforced();
        if (current > 0) {
            style = headMat.style();
            reinforced = current;
        }
        if ((current = handleMat.reinforced()) > 0 && current > reinforced) {
            style = handleMat.style();
            reinforced = current;
        }
        if (this.getPartAmount() >= 3 && (current = accessoryMat.reinforced()) > 0 && current > reinforced) {
            style = accessoryMat.style();
            reinforced = current;
        }
        if (this.getPartAmount() >= 4 && (current = extraMat.reinforced()) > 0 && current > reinforced) {
            style = extraMat.style();
            reinforced = current;
        }
        if ((reinforced += unbreaking - reinforced) > 0) {
            return style + this.getReinforcedString(reinforced);
        }
        return "";
    }

    String getReinforcedString(int reinforced) {
        if (reinforced > 9) {
            return StatCollector.func_74838_a((String)"tool.unbreakable");
        }
        String ret = StatCollector.func_74838_a((String)"tool.reinforced") + " ";
        switch (reinforced) {
            case 1: {
                ret = ret + "I";
                break;
            }
            case 2: {
                ret = ret + "II";
                break;
            }
            case 3: {
                ret = ret + "III";
                break;
            }
            case 4: {
                ret = ret + "IV";
                break;
            }
            case 5: {
                ret = ret + "V";
                break;
            }
            case 6: {
                ret = ret + "VI";
                break;
            }
            case 7: {
                ret = ret + "VII";
                break;
            }
            case 8: {
                ret = ret + "VIII";
                break;
            }
            case 9: {
                ret = ret + "IX";
                break;
            }
            default: {
                ret = ret + "X";
            }
        }
        return ret;
    }

    public void onEntityDamaged(World world, EntityLivingBase player, Entity entity) {
    }

    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (Map.Entry<Integer, ToolMaterial> pairs : TConstructRegistry.toolMaterials.entrySet()) {
            ToolMaterial material = pairs.getValue();
            this.buildTool(pairs.getKey(), ToolBuilder.defaultToolName(material, this), list);
        }
    }

    public void buildTool(int id, String name, List list) {
        Item accessory = this.getAccessoryItem();
        ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, id) : null;
        Item extra = this.getExtraItem();
        ItemStack extraStack = extra != null ? new ItemStack(extra, 1, id) : null;
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, id), accessoryStack, extraStack, name);
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    public abstract Item getHeadItem();

    public abstract Item getAccessoryItem();

    public Item getExtraItem() {
        return null;
    }

    public Item getHandleItem() {
        return TinkerTools.toolRod;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            mod.updateTool(this, stack, world, entity);
        }
    }

    @Override
    public abstract String[] getTraits();

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        boolean cancelHarvest = false;
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            if (!mod.beforeBlockBreak(this, stack, x, y, z, (EntityLivingBase)player)) continue;
            cancelHarvest = true;
        }
        return cancelHarvest;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase player) {
        if (!itemstack.func_77942_o()) {
            return false;
        }
        for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
            mod.afterBlockBreak(this, itemstack, block, x, y, z, player);
        }
        if (block != null && (double)block.func_149712_f(world, x, y, z) != 0.0) {
            return AbilityHelper.onBlockChanged(itemstack, world, block, x, y, z, player, this.random);
        }
        return true;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 0.0f;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74775_l("InfiTool").func_74767_n("Broken")) {
            return 0.1f;
        }
        return 1.0f;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, entity, this, 0);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase mob, EntityLivingBase player) {
        return true;
    }

    public boolean pierceArmor() {
        return false;
    }

    public float chargeAttack() {
        return 1.0f;
    }

    public int getDamageVsEntity(Entity par1Entity) {
        return this.damageVsEntity;
    }

    public float getDurabilityModifier() {
        return 1.0f;
    }

    public float getRepairCost() {
        return this.getDurabilityModifier();
    }

    public float getDamageModifier() {
        return 1.0f;
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                switch (renderPass) {
                    case 0: {
                        return this.getCorrectColor(stack, renderPass, tags, "Handle", this.handleIcons);
                    }
                    case 1: {
                        return tags.func_74767_n("Broken") ? this.getCorrectColor(stack, renderPass, tags, "Head", this.brokenIcons) : this.getCorrectColor(stack, renderPass, tags, "Head", this.headIcons);
                    }
                    case 2: {
                        return this.getCorrectColor(stack, renderPass, tags, "Accessory", this.accessoryIcons);
                    }
                    case 3: {
                        return this.getCorrectColor(stack, renderPass, tags, "Extra", this.extraIcons);
                    }
                }
            }
        }
        return super.func_82790_a(stack, renderPass);
    }

    protected int getCorrectColor(ItemStack stack, int renderPass, NBTTagCompound tags, String key, Map<Integer, IIcon> map) {
        if (tags.func_74764_b(key + "Color")) {
            return tags.func_74762_e(key + "Color");
        }
        Integer matId = tags.func_74762_e("Render" + key);
        if (map.containsKey(matId)) {
            return super.func_82790_a(stack, renderPass);
        }
        return this.getDefaultColor(renderPass, matId);
    }

    protected int getDefaultColor(int renderPass, int materialID) {
        if (TConstructRegistry.getMaterial(materialID) != null) {
            return TConstructRegistry.getMaterial(materialID).primaryColor();
        }
        return -1;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean used = false;
        int hotbarSlot = player.field_71071_by.field_70461_c;
        int itemSlot = hotbarSlot == 0 ? 8 : hotbarSlot + 1;
        ItemStack nearbyStack = null;
        if (hotbarSlot < 8 && (nearbyStack = player.field_71071_by.func_70301_a(itemSlot)) != null) {
            Item item = nearbyStack.func_77973_b();
            if (item instanceof ItemPotion) {
                ItemPotion cfr_ignored_0 = (ItemPotion)item;
                if (ItemPotion.func_77831_g((int)nearbyStack.func_77960_j())) {
                    nearbyStack = item.func_77659_a(nearbyStack, world, player);
                    if (nearbyStack.field_77994_a < 1) {
                        nearbyStack = null;
                        player.field_71071_by.func_70299_a(itemSlot, null);
                    }
                }
            }
            if (item != null && item == TinkerWeaponry.shuriken) {
                item.func_77659_a(nearbyStack, world, player);
            }
        }
        return stack;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        return !tags.func_74767_n("Broken") && this.getDamage(stack) > 0;
    }

    public int getMaxDamage(ItemStack stack) {
        return 100;
    }

    public int getDamage(ItemStack stack) {
        int max;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        if (tags.func_74764_b("Energy")) {
            int energy = tags.func_74762_e("Energy");
            max = this.getMaxEnergyStored(stack);
            if (energy > 0) {
                int damage = (max - energy) * 100 / max;
                if (damage == 0 && max - energy > 0) {
                    damage = 1;
                }
                super.setDamage(stack, damage);
                return damage;
            }
        }
        int dur = tags.func_74775_l("InfiTool").func_74762_e("Damage");
        max = tags.func_74775_l("InfiTool").func_74762_e("TotalDurability");
        int damage = 0;
        if (max > 0) {
            damage = dur * 100 / max;
        }
        if (damage == 0 && dur > 0) {
            damage = 1;
        }
        super.setDamage(stack, damage);
        return damage;
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.getDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        int change = damage - stack.func_77960_j();
        if (change == 0) {
            return;
        }
        AbilityHelper.damageTool(stack, change, null, false);
        this.getDamage(stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new FancyEntityItem(world, location, itemstack);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        NBTTagCompound tags = container.func_77978_p();
        if (tags == null || !tags.func_74764_b("Energy")) {
            return 0;
        }
        int energy = tags.func_74762_e("Energy");
        int energyReceived = tags.func_74764_b("EnergyReceiveRate") ? tags.func_74762_e("EnergyReceiveRate") : this.maxReceive;
        int maxEnergy = tags.func_74764_b("EnergyMax") ? tags.func_74762_e("EnergyMax") : this.capacity;
        energyReceived = Math.min(maxEnergy - energy, Math.min(energyReceived, maxReceive));
        if (!simulate) {
            tags.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        NBTTagCompound tags = container.func_77978_p();
        if (tags == null || !tags.func_74764_b("Energy")) {
            return 0;
        }
        int energy = tags.func_74762_e("Energy");
        int energyExtracted = tags.func_74764_b("EnergyExtractionRate") ? tags.func_74762_e("EnergyExtractionRate") : this.maxExtract;
        energyExtracted = Math.min(energy, Math.min(energyExtracted, maxExtract));
        if (!simulate) {
            tags.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ItemStack container) {
        NBTTagCompound tags = container.func_77978_p();
        if (tags == null || !tags.func_74764_b("Energy")) {
            return 0;
        }
        return tags.func_74762_e("Energy");
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ItemStack container) {
        NBTTagCompound tags = container.func_77978_p();
        if (tags == null || !tags.func_74764_b("Energy")) {
            return 0;
        }
        if (tags.func_74764_b("EnergyMax")) {
            return tags.func_74762_e("EnergyMax");
        }
        return this.capacity;
    }

    @Optional.Method(modid="CoFHCore")
    public boolean isLastHeldItemEqual(ItemStack current, ItemStack previous) {
        NBTTagCompound prevTags;
        if (!current.func_77942_o() || !previous.func_77942_o()) {
            return false;
        }
        NBTTagCompound curTags = current.func_77978_p();
        if (curTags == (prevTags = previous.func_77978_p())) {
            return true;
        }
        if (!curTags.func_74764_b("InfiTool") || !prevTags.func_74764_b("InfiTool")) {
            return false;
        }
        curTags = (NBTTagCompound)curTags.func_74737_b();
        prevTags = (NBTTagCompound)prevTags.func_74737_b();
        curTags.func_82580_o("Energy");
        prevTags.func_82580_o("Energy");
        curTags.func_74775_l("InfiTool").func_82580_o("Damage");
        prevTags.func_74775_l("InfiTool").func_82580_o("Damage");
        return curTags.equals((Object)prevTags);
    }
}

