/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.mechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mantle.blocks.BlockUtils;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.TConstruct;
import tconstruct.mechworks.landmine.Helper;
import tconstruct.mechworks.logic.LandmineExplodeLogic;
import tconstruct.mechworks.logic.TileEntityLandmine;
import tconstruct.world.model.RenderLandmine;

public class BlockLandmine
extends BlockContainer {
    boolean explodeOnBroken = false;

    public BlockLandmine() {
        super(Material.field_151590_u);
        this.func_149675_a(true);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.0625f, 0.9375f);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityLandmine te;
        if (world.func_147439_a(x, y, z) == this && world.func_147438_o(x, y, z) instanceof TileEntityLandmine && (te = (TileEntityLandmine)world.func_147438_o(x, y, z)) != null && te.func_70301_a(3) != null && te.func_70301_a(3).func_77973_b() instanceof ItemBlock) {
            return BlockUtils.getBlockFromItem((Item)te.func_70301_a(3).func_77973_b()).func_149750_m();
        }
        return super.getLightValue(world, x, y, z);
    }

    public int func_149738_a(World par1World) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntityLandmine te = (TileEntityLandmine)par1IBlockAccess.func_147438_o(par2, par3, par4);
        ItemStack camo = te.func_70301_a(3);
        if (camo != null) {
            return BlockUtils.getBlockFromItem((Item)camo.func_77973_b()).func_149691_a(par5, camo.func_77960_j());
        }
        return this.func_149691_a(par5, par1IBlockAccess.func_72805_g(par2, par3, par4));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderLandmine.model;
    }

    public void func_149699_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        super.func_149699_a(par1World, par2, par3, par4, par5EntityPlayer);
        if (this.explodeOnBroken) {
            this.checkExplosion(par1World, par2, par3, par4, true);
        }
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("tinker:Landmine");
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        par5EntityPlayer.openGui((Object)TConstruct.instance, 10, par1World, par2, par3, par4);
        return true;
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5Block, int par6) {
        TileEntityLandmine tileentity = (TileEntityLandmine)par1World.func_147438_o(par2, par3, par4);
        int metadata = par1World.func_72805_g(par2, par3, par4);
        if (!(tileentity == null || this.explodeOnBroken && this.hasItems(par1World, par2, par3, par4) || par6 == 193 || tileentity.isExploding)) {
            if (this != null) {
                ItemStack is = new ItemStack((Block)this, 1, this.func_149692_a(tileentity.triggerType));
                if (tileentity.func_145818_k_()) {
                    is.func_151001_c(tileentity.func_145825_b());
                }
                this.func_149642_a(par1World, par2, par3, par4, new ItemStack((Block)this, 1, this.func_149692_a(tileentity.triggerType)));
            }
            for (int j1 = 0; j1 < tileentity.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileentity.func_70301_a(j1);
                if (itemstack == null) continue;
                while (itemstack.field_77994_a > 0) {
                    int ss = itemstack.field_77994_a;
                    itemstack.field_77994_a -= ss;
                    EntityItem entityitem = new EntityItem(par1World, (double)par2, (double)par3, (double)par4, new ItemStack(itemstack.func_77973_b(), ss, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = f3;
                    entityitem.field_70181_x = f3 + 0.2f;
                    entityitem.field_70179_y = f3;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
        } else if (this.explodeOnBroken) {
            this.checkExplosion(par1World, par2, par3, par4, true);
        }
        super.func_149749_a(par1World, par2, par3, par4, par5Block, par6);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
    }

    public boolean func_149655_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return true;
    }

    public boolean func_149707_d(World par1World, int par2, int par3, int par4, int par5) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)par5);
        return dir == ForgeDirection.DOWN && par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN) || dir == ForgeDirection.UP && par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || dir == ForgeDirection.NORTH && par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || dir == ForgeDirection.EAST && par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST);
    }

    public boolean func_149742_c(World par1World, int par2, int par3, int par4) {
        return par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) || par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) || par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) || par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) || par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) || par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN);
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int j1 = par9 & 8;
        int k1 = par9 & 7;
        int b0 = -1;
        if (par5 == 0 && par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN)) {
            b0 = 0;
        }
        if (par5 == 1 && par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP)) {
            b0 = 5;
        }
        if (par5 == 2 && par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH)) {
            b0 = 4;
        }
        if (par5 == 3 && par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH)) {
            b0 = 3;
        }
        if (par5 == 4 && par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST)) {
            b0 = 2;
        }
        if (par5 == 5 && par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST)) {
            b0 = 1;
        }
        return b0 + j1;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = par1World.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        int j1 = l & 8;
        if (i1 == BlockLandmine.invertMetadata(1)) {
            if ((MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 1) == 0) {
                par1World.func_72921_c(par2, par3, par4, 5 | j1, 2);
            } else {
                par1World.func_72921_c(par2, par3, par4, 6 | j1, 2);
            }
        } else if (i1 == BlockLandmine.invertMetadata(0)) {
            if ((MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 1) == 0) {
                par1World.func_72921_c(par2, par3, par4, 7 | j1, 2);
            } else {
                par1World.func_72921_c(par2, par3, par4, 0 | j1, 2);
            }
        }
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityLandmine)par1World.func_147438_o(par2, par3, par4)).setGuiDisplayName(par6ItemStack.func_82833_r());
        }
    }

    public static int invertMetadata(int par0) {
        switch (par0) {
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5Block) {
        this.checkPlacement(par1World, par2, par3, par4, par5Block);
        this.checkExplosion(par1World, par2, par3, par4, false);
    }

    public void checkPlacement(World par1World, int par2, int par3, int par4, Block par5Block) {
        if (this.checkIfAttachedToBlock(par1World, par2, par3, par4)) {
            int i1 = par1World.func_72805_g(par2, par3, par4) & 7;
            boolean flag = false;
            if (!par1World.isSideSolid(par2 - 1, par3, par4, ForgeDirection.EAST) && i1 == 1) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2 + 1, par3, par4, ForgeDirection.WEST) && i1 == 2) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3, par4 - 1, ForgeDirection.SOUTH) && i1 == 3) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3, par4 + 1, ForgeDirection.NORTH) && i1 == 4) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) && i1 == 5) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3 - 1, par4, ForgeDirection.UP) && i1 == 6) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN) && i1 == 0) {
                flag = true;
            }
            if (!par1World.isSideSolid(par2, par3 + 1, par4, ForgeDirection.DOWN) && i1 == 7) {
                flag = true;
            }
            if (flag) {
                this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
                WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
            }
        }
    }

    private boolean checkIfAttachedToBlock(World par1World, int par2, int par3, int par4) {
        if (!this.func_149742_c(par1World, par2, par3, par4)) {
            this.func_149697_b(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
            WorldHelper.setBlockToAir((World)par1World, (int)par2, (int)par3, (int)par4);
            return false;
        }
        return true;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.field_72995_K) {
            this.checkExplosion(par1World, par2, par3, par4, false);
        }
    }

    public void func_149670_a(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        if (!par1World.field_72995_K) {
            this.checkExplosion(par1World, par2, par3, par4, false);
        }
    }

    public void checkExplosion(World par1World, int par2, int par3, int par4, boolean skipCheck) {
        if ((skipCheck || this.getMineState(par1World, par2, par3, par4) > 0) && this.hasItems(par1World, par2, par3, par4)) {
            TileEntityLandmine te = (TileEntityLandmine)par1World.func_147438_o(par2, par3, par4);
            if (te.soundcountything <= 0) {
                par1World.func_72908_a((double)par2 + 0.5, (double)par3 + 0.1, (double)par4 + 0.5, "random.click", 0.3f, 0.6f);
                te.setSoundPlayed();
            }
            new LandmineExplodeLogic(par1World, par2, par3, par4, this.getMineTriggerer(par1World, par2, par3, par4)).explode();
        }
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    private boolean hasItems(World par1World, int par2, int par3, int par4) {
        TileEntityLandmine te = (TileEntityLandmine)par1World.func_147438_o(par2, par3, par4);
        return te != null && te.func_70301_a(0) != null || te.func_70301_a(1) != null || te.func_70301_a(2) != null;
    }

    protected int getMineState(World par1World, int par2, int par3, int par4) {
        BlockPressurePlate.Sensitivity triggerType;
        TileEntityLandmine te = (TileEntityLandmine)par1World.func_147438_o(par2, par3, par4);
        if (te == null) {
            return 0;
        }
        switch (te.triggerType) {
            case 0: {
                triggerType = BlockPressurePlate.Sensitivity.everything;
                break;
            }
            case 1: {
                triggerType = BlockPressurePlate.Sensitivity.mobs;
                break;
            }
            case 2: {
                triggerType = BlockPressurePlate.Sensitivity.players;
                break;
            }
            default: {
                triggerType = null;
            }
        }
        if (triggerType != null) {
            List list = null;
            if (triggerType == BlockPressurePlate.Sensitivity.everything) {
                list = par1World.func_72839_b((Entity)null, this.getSensitiveAABB(par1World, par2, par3, par4));
            }
            if (triggerType == BlockPressurePlate.Sensitivity.mobs) {
                list = par1World.func_72872_a(EntityLivingBase.class, this.getSensitiveAABB(par1World, par2, par3, par4));
            }
            if (triggerType == BlockPressurePlate.Sensitivity.players) {
                list = par1World.func_72872_a(EntityPlayer.class, this.getSensitiveAABB(par1World, par2, par3, par4));
            }
            if (list != null && !list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.func_145773_az()) continue;
                    return 1;
                }
            }
        }
        return par1World.func_72864_z(par2, par3, par4) ? 1 : 0;
    }

    protected AxisAlignedBB getSensitiveAABB(World par1World, int par2, int par3, int par4) {
        float f = 0.125f;
        int l = par1World.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        float minX = (float)par2 + f;
        float minY = par3;
        float minZ = (float)par4 + f;
        float maxX = (float)(par2 + 1) - f;
        float maxY = (float)par3 + 0.25f;
        float maxZ = (float)(par4 + 1) - f;
        ForgeDirection dir = Helper.convertMetaToForgeOrientation(i1);
        switch (dir) {
            case DOWN: {
                break;
            }
            case UP: {
                minY = (float)par3 + 0.75f;
                maxY = par3 + 1;
                break;
            }
            default: {
                minX = par2;
                minY = par3;
                minZ = par4;
                maxX = par2 + 1;
                maxY = par3 + 1;
                maxZ = par4 + 1;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public Entity getMineTriggerer(World par1World, int par2, int par3, int par4) {
        BlockPressurePlate.Sensitivity triggerType;
        TileEntityLandmine te = (TileEntityLandmine)par1World.func_147438_o(par2, par3, par4);
        if (te == null) {
            return null;
        }
        switch (te.triggerType) {
            case 0: {
                triggerType = BlockPressurePlate.Sensitivity.everything;
                break;
            }
            case 1: {
                triggerType = BlockPressurePlate.Sensitivity.mobs;
                break;
            }
            case 2: {
                triggerType = BlockPressurePlate.Sensitivity.players;
                break;
            }
            default: {
                triggerType = null;
            }
        }
        if (triggerType != null) {
            List list = null;
            if (triggerType == BlockPressurePlate.Sensitivity.everything) {
                list = par1World.func_72839_b((Entity)null, AxisAlignedBB.func_72330_a((double)((double)par2 + 0.0), (double)((double)par3 + 0.0), (double)((double)par4 + 0.0), (double)((double)par2 + 1.0), (double)((double)par3 + 1.0), (double)((double)par4 + 1.0)));
            }
            if (triggerType == BlockPressurePlate.Sensitivity.mobs) {
                list = par1World.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)par2 + 0.0), (double)((double)par3 + 0.0), (double)((double)par4 + 0.0), (double)((double)par2 + 1.0), (double)((double)par3 + 1.0), (double)((double)par4 + 1.0)));
            }
            if (triggerType == BlockPressurePlate.Sensitivity.players) {
                list = par1World.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)par2 + 0.0), (double)((double)par3 + 0.0), (double)((double)par4 + 0.0), (double)((double)par2 + 1.0), (double)((double)par3 + 1.0), (double)((double)par4 + 1.0)));
            }
            if (list != null && !list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.func_145773_az()) continue;
                    return entity;
                }
            }
        }
        return new EntityTNTPrimed(par1World, (double)par2, (double)par3, (double)par4, (EntityLivingBase)null);
    }

    public boolean func_149659_a(Explosion par1Explosion) {
        return false;
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int l = par1IBlockAccess.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        ForgeDirection dir = Helper.convertMetaToForgeOrientation(i1);
        switch (dir) {
            case DOWN: {
                this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.0625f, 0.9375f);
                break;
            }
            case UP: {
                this.func_149676_a(0.0625f, 0.9375f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.0625f, 0.0625f, 0.0f, 0.9375f, 0.9375f, 0.0625f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0625f, 0.0625f, 0.9375f, 0.9375f, 0.9375f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.9375f, 0.0625f, 0.0625f, 1.0f, 0.9375f, 0.9375f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.0f, 0.0625f, 0.0625f, 0.0625f, 0.9375f, 0.9375f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLandmine();
    }
}

