/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.accessory;

import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import tconstruct.library.accessory.AccessoryCore;
import tconstruct.library.modifier.IModifyable;
import tconstruct.modifiers.tools.ItemModTypeFilter;

public class GloveSpeed
extends ItemModTypeFilter {
    String tooltipName = "\u00a74" + StatCollector.func_74838_a((String)"modifier.tooltip.Haste");
    int max = 100;

    public GloveSpeed(int effect, ItemStack[] items, int[] values) {
        super(effect, "Redstone", items, values);
    }

    @Override
    protected boolean canModify(ItemStack input, ItemStack[] modifiers) {
        if (input.func_77973_b() instanceof AccessoryCore) {
            if (!Arrays.asList(((AccessoryCore)input.func_77973_b()).getTraits()).contains("glove")) {
                return false;
            }
            NBTTagCompound tags = this.getModifierTag(input);
            if (!tags.func_74764_b(this.key)) {
                return tags.func_74762_e("Modifiers") > 0 && this.matchingAmount(modifiers) <= this.max;
            }
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] + this.matchingAmount(modifiers) <= keyPair[1]) {
                return true;
            }
            if (keyPair[0] == keyPair[1]) {
                return tags.func_74762_e("Modifiers") > 0;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] modifiers, ItemStack input) {
        int mods;
        NBTTagCompound tags = this.getModifierTag(input);
        int increase = this.matchingAmount(modifiers);
        int current = 0;
        if (tags.func_74764_b(this.key)) {
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                mods = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --mods);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.func_74783_a(this.key, keyPair);
            }
            current = keyPair[0];
            this.updateModTag(input, keyPair);
        } else {
            mods = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --mods);
            String modName = "\u00a74Redstone (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(input, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            current = keyPair[0];
            tags.func_74783_a(this.key, keyPair);
        }
        int miningSpeed = tags.func_74762_e("MiningSpeed");
        int boost = 1;
        tags.func_74768_a("MiningSpeed", miningSpeed += increase * boost);
    }

    void updateModTag(ItemStack input, int[] keys) {
        NBTTagCompound tags = this.getModifierTag(input);
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(IModifyable type) {
        return type.getModifyType().equals("Accessory");
    }
}

