/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import cpw.mods.fml.common.registry.GameData;
import exterminatorJeff.undergroundBiomes.api.BlockCodes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import rtg.config.rtg.ConfigRTG;
import rtg.util.ModPresenceTester;
import rtg.util.UBColumnCache;

public class BoulderUtil {
    private static final ModPresenceTester undergroundBiomesMod = new ModPresenceTester("UndergroundBiomes");
    private static final ModPresenceTester harderUndergroundMod = new ModPresenceTester("HarderUnderground");
    private static UBColumnCache ubColumnCache = undergroundBiomesMod.present() ? new UBColumnCache() : null;
    private static Block unstableCobbleBlock = harderUndergroundMod.present() ? (Block)GameData.getBlockRegistry().func_82594_a("HarderUnderground:unstable_stone") : Blocks.field_150347_e;
    private static byte unstableCobbleMeta = (byte)(harderUndergroundMod.present() ? 3 : 0);

    public Block getBoulderBlock(Block defaultBlock, int worldX, int worldY, int worldZ) {
        if (defaultBlock == Blocks.field_150347_e) {
            if (undergroundBiomesMod.present() && ConfigRTG.enableUBCBoulders) {
                BlockCodes cobble = ubColumnCache.column(worldX, worldZ).cobblestone(worldY);
                return cobble.block;
            }
            if (harderUndergroundMod.present()) {
                return unstableCobbleBlock;
            }
            return defaultBlock;
        }
        return defaultBlock;
    }

    public byte getBoulderMeta(Block defaultBlock, byte defaultMeta, int worldX, int worldY, int worldZ) {
        if (defaultBlock == Blocks.field_150347_e) {
            if (undergroundBiomesMod.present()) {
                BlockCodes cobble = ubColumnCache.column(worldX, worldZ).cobblestone(worldY);
                return (byte)cobble.metadata;
            }
            if (harderUndergroundMod.present()) {
                return unstableCobbleMeta;
            }
            return defaultMeta;
        }
        return defaultMeta;
    }
}

