/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class WorldUtil {
    private World world;

    public WorldUtil(World world) {
        this.world = world;
    }

    public boolean isSurroundedByBlock(Block checkBlock, int checkDistance, SurroundCheckType checkType, Random rand, int x, int y, int z) {
        switch (checkType) {
            case FULL: {
                for (int ix = -checkDistance; ix <= checkDistance; ++ix) {
                    for (int iz = -checkDistance; iz <= checkDistance; ++iz) {
                        if (x == ix && z == iz || this.world.func_147439_a(x + ix, y, z + iz) == checkBlock) continue;
                        return false;
                    }
                }
                break;
            }
            case CARDINAL: {
                for (int i = checkDistance; i > 0; --i) {
                    if (this.world.func_147439_a(x, y, z + i) != checkBlock) {
                        return false;
                    }
                    if (this.world.func_147439_a(x, y, z - i) != checkBlock) {
                        return false;
                    }
                    if (this.world.func_147439_a(x + i, y, z) != checkBlock) {
                        return false;
                    }
                    if (this.world.func_147439_a(x - i, y, z) == checkBlock) continue;
                    return false;
                }
                break;
            }
            case ORDINAL: {
                for (int i = checkDistance; i > 0; --i) {
                    if (this.world.func_147439_a(x + i, y, z + i) != checkBlock) {
                        return false;
                    }
                    if (this.world.func_147439_a(x + i, y, z - i) != checkBlock) {
                        return false;
                    }
                    if (this.world.func_147439_a(x - i, y, z + i) != checkBlock) {
                        return false;
                    }
                    if (this.world.func_147439_a(x - i, y, z - i) == checkBlock) continue;
                    return false;
                }
                break;
            }
            case UP: {
                for (int i = checkDistance; i > 0; --i) {
                    Block b = this.world.func_147439_a(x, y + i, z);
                    if (b == checkBlock) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public static enum SurroundCheckType {
        FULL,
        CARDINAL,
        ORDINAL,
        UP;

    }
}

