/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.RandomUtil;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenBlock;

public class DecoCobwebs
extends DecoBase {
    public float strengthFactor = 2.0f;
    public int minY = 1;
    public int maxY = 255;
    public int chance = 10;
    public Block adjacentBlock = Blocks.field_150350_a;
    public byte adjacentBlockMeta = 0;
    public int minAdjacents = 1;

    public DecoCobwebs() {
        this.addDecoTypes(DecoBase.DecoType.COBWEB);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed) {
            WorldGenBlock worldGenerator = new WorldGenBlock(Blocks.field_150321_G, 0, Blocks.field_150350_a, 0, this.adjacentBlock, this.adjacentBlockMeta, this.minAdjacents);
            int l1 = 0;
            while ((float)l1 < this.strengthFactor * strength) {
                int i1 = chunkX + rand.nextInt(16);
                int j1 = chunkY + rand.nextInt(16);
                int k1 = RandomUtil.getRandomInt(rand, this.minY, this.maxY);
                if (rand.nextInt(this.chance) == 0) {
                    worldGenerator.func_76484_a(world, rand, i1, k1, j1);
                }
                ++l1;
            }
        }
    }
}

