/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenJungleCacti;

public class DecoJungleCacti
extends DecoBase {
    public float strengthFactor = 8.0f;
    public int maxY = 255;
    public boolean sandOnly = false;
    public int extraHeight = 7;
    public byte sandMeta = 1;

    public DecoJungleCacti() {
        this.addDecoTypes(DecoBase.DecoType.CACTUS);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            WorldGenJungleCacti worldGenerator = new WorldGenJungleCacti(this.sandOnly, rand.nextInt(this.extraHeight), this.sandMeta);
            int i = 0;
            while ((float)i < this.strengthFactor * strength) {
                int intX = chunkX + rand.nextInt(16);
                int intY = rand.nextInt(160);
                int intZ = chunkY + rand.nextInt(16);
                if (intY < this.maxY) {
                    worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
                }
                ++i;
            }
        }
    }
}

