/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco.helper;

import java.util.Random;
import net.minecraft.world.World;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class DecoHelperRandomSplit
extends DecoBase {
    public DecoBase[] decos = new DecoBase[0];
    public int[] chances = new int[0];

    @Override
    public boolean properlyDefined() {
        for (int i = 0; i < this.decos.length; ++i) {
            if (this.decos[i].properlyDefined()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed) {
            if (this.decos.length < 1 || this.chances.length < 1 || this.decos.length != this.chances.length) {
                throw new RuntimeException("DecoHelperRandomSplit is confused.");
            }
            int totalChances = 0;
            for (int i = 0; i < this.decos.length; ++i) {
                totalChances += this.chances[i];
            }
            int chosen = rand.nextInt(totalChances);
            for (int i = 0; i < this.decos.length; ++i) {
                if (chosen < this.chances[i]) {
                    this.decos[i].generate(biome, world, rand, chunkX, chunkY, simplex, cell, strength, river, hasPlacedVillageBlocks);
                }
                chosen -= this.chances[i];
            }
        }
    }
}

