/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.chromaticraft;

import cpw.mods.fml.common.Loader;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.api.biome.chromaticraft.config.BiomeConfigCC;
import rtg.util.Logger;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.chromaticraft.RealisticBiomeCCEnderForest;
import rtg.world.biome.realistic.chromaticraft.RealisticBiomeCCLuminousCliffs;
import rtg.world.biome.realistic.chromaticraft.RealisticBiomeCCRainbowForest;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeCCBase
extends RealisticBiomeBase {
    public static RealisticBiomeBase ccEnderForest;
    public static RealisticBiomeBase ccLuminousCliffs;
    public static RealisticBiomeBase ccRainbowForest;

    public RealisticBiomeCCBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        super(config, b, riverbiome, t, s);
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 0;
    }

    public static void addBiomes() {
        if (Loader.isModLoaded((String)"ChromatiCraft")) {
            BiomeGenBase[] b = BiomeGenBase.func_150565_n();
            for (int i = 0; i < 256; ++i) {
                if (b[i] == null) continue;
                if (b[i].field_76791_y == null) {
                    Logger.warn("Biome ID %d has no name.", b[i].field_76756_M);
                    continue;
                }
                BiomeGenBase ccBiome = b[i];
                String biomeName = ccBiome.field_76791_y;
                String biomeClass = ccBiome.func_150562_l().getName();
                if (biomeName == "Ender Forest" && biomeClass == "Reika.ChromatiCraft.World.BiomeEnderForest") {
                    ccEnderForest = new RealisticBiomeCCEnderForest(ccBiome, BiomeConfigCC.biomeConfigCCEnderForest);
                    continue;
                }
                if (biomeName == "Luminous Cliffs" && biomeClass == "Reika.ChromatiCraft.World.BiomeGlowingCliffs") {
                    ccLuminousCliffs = new RealisticBiomeCCLuminousCliffs(ccBiome, BiomeConfigCC.biomeConfigCCLuminousCliffs);
                    continue;
                }
                if (biomeName != "Rainbow Forest" || biomeClass != "Reika.ChromatiCraft.World.BiomeRainbowForest") continue;
                ccRainbowForest = new RealisticBiomeCCRainbowForest(ccBiome, BiomeConfigCC.biomeConfigCCRainbowForest);
            }
        }
    }
}

