/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.highlands;

import highlands.api.HighlandsBiomes;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.biome.deco.DecoBaseBiomeDecorations;
import rtg.world.biome.realistic.highlands.RealisticBiomeHLBase;
import rtg.world.gen.surface.highlands.SurfaceHLLowlands;
import rtg.world.gen.terrain.TerrainBase;
import rtg.world.gen.terrain.highlands.TerrainHLLowlands;

public class RealisticBiomeHLLowlands
extends RealisticBiomeHLBase {
    public static BiomeGenBase hlBiome = HighlandsBiomes.lowlands;
    public static Block topBlock = RealisticBiomeHLLowlands.hlBiome.field_76752_A;
    public static Block fillerBlock = RealisticBiomeHLLowlands.hlBiome.field_76753_B;
    private float largeBendSize = 25.0f;
    private float mediumBendSize = 8.0f;
    private float lakeInterval = 300.0f;

    public RealisticBiomeHLLowlands(BiomeConfig config) {
        super(config, hlBiome, BiomeGenBase.field_76781_i, (TerrainBase)new TerrainHLLowlands(), new SurfaceHLLowlands(config, topBlock, fillerBlock));
        DecoBaseBiomeDecorations decoBaseBiomeDecorations = new DecoBaseBiomeDecorations();
        this.addDeco(decoBaseBiomeDecorations);
    }

    @Override
    public float lakePressure(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        float result = super.lakePressure(simplex, simplexCell, x, y, border);
        return Math.min(result, this.lowlandsLakePressure(simplex, simplexCell, x, y, border));
    }

    public float lowlandsLakePressure(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        SimplexOctave.Disk jitter = new SimplexOctave.Disk();
        simplex.riverJitter().evaluateNoise((double)x / 40.0, (double)y / 40.0, jitter);
        double pX = (double)x + jitter.deltax() * (double)this.largeBendSize;
        double pY = (double)y + jitter.deltay() * (double)this.largeBendSize;
        simplex.mountain().evaluateNoise((double)x / 13.0, (double)y / 13.0, jitter);
        double[] lakeResults = simplexCell.river().eval((float)(pX += jitter.deltax() * (double)this.mediumBendSize) / this.lakeInterval, (float)(pY += jitter.deltay() * (double)this.mediumBendSize) / this.lakeInterval);
        float results = 1.0f - (float)((lakeResults[1] - lakeResults[0]) / lakeResults[1]);
        if ((double)results > 1.01) {
            throw new RuntimeException("" + lakeResults[0] + " , " + lakeResults[1]);
        }
        if ((double)results < -0.01) {
            throw new RuntimeException("" + lakeResults[0] + " , " + lakeResults[1]);
        }
        return results;
    }
}

