/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.thaumcraft;

import cpw.mods.fml.common.Loader;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.api.biome.thaumcraft.config.BiomeConfigTC;
import rtg.util.Logger;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.thaumcraft.RealisticBiomeTCEerie;
import rtg.world.biome.realistic.thaumcraft.RealisticBiomeTCMagicalForest;
import rtg.world.biome.realistic.thaumcraft.RealisticBiomeTCTaintedLand;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeTCBase
extends RealisticBiomeBase {
    public static RealisticBiomeBase tcMagicalForest;
    public static RealisticBiomeBase tcTaintedLand;
    public static RealisticBiomeBase tcEerie;

    public RealisticBiomeTCBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        super(config, b, riverbiome, t, s);
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 0;
    }

    public static void addBiomes() {
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            BiomeGenBase[] b = BiomeGenBase.func_150565_n();
            for (int i = 0; i < 256; ++i) {
                if (b[i] == null) continue;
                if (b[i].field_76791_y == null) {
                    Logger.warn("Biome ID %d has no name.", b[i].field_76756_M);
                    continue;
                }
                BiomeGenBase tcBiome = b[i];
                String biomeName = tcBiome.field_76791_y;
                String biomeClass = tcBiome.func_150562_l().getName();
                if (biomeName == "Magical Forest" && biomeClass == "thaumcraft.common.lib.world.biomes.BiomeGenMagicalForest") {
                    tcMagicalForest = new RealisticBiomeTCMagicalForest(tcBiome, BiomeConfigTC.biomeConfigTCMagicalForest);
                    continue;
                }
                if (biomeName == "Tainted Land" && biomeClass == "thaumcraft.common.lib.world.biomes.BiomeGenTaint") {
                    tcTaintedLand = new RealisticBiomeTCTaintedLand(tcBiome, BiomeConfigTC.biomeConfigTCTaintedLand);
                    continue;
                }
                if (!biomeName.equals("Eerie") || !biomeClass.contains("thaumcraft.common.lib.world.biomes")) continue;
                tcEerie = new RealisticBiomeTCEerie(tcBiome, BiomeConfigTC.biomeConfigTCEerie);
            }
        }
    }
}

