/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import rtg.config.rtg.ConfigRTG;

public class WorldGenShrubRTG
extends WorldGenerator {
    private int size;
    private Block logBlock;
    private int logMeta;
    private Block leaveBlock;
    private int leaveMeta;
    private boolean sand;

    public WorldGenShrubRTG(int s, Block log, byte logByte, Block leav, byte leavByte) {
        this(s, log, logByte, leav, leavByte, false);
    }

    public WorldGenShrubRTG(int s, Block log, byte logByte, Block leav, byte leavByte, boolean sa) {
        this.size = s;
        this.sand = sa;
        this.logBlock = log;
        this.logMeta = logByte;
        this.leaveBlock = leav;
        this.leaveMeta = leavByte;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int width = this.size > 6 ? 6 : this.size;
        int height = this.size > 3 ? 2 : 1;
        for (int i = 0; i < this.size; ++i) {
            int rX = rand.nextInt(width * 2) - width;
            int rY = rand.nextInt(height);
            int rZ = rand.nextInt(width * 2) - width;
            if (i == 0 && this.size > 4) {
                this.buildLeaves(world, x + rX, y, z + rZ, 3);
                continue;
            }
            if (i == 1 && this.size > 2) {
                this.buildLeaves(world, x + rX, y, z + rZ, 2);
                continue;
            }
            this.buildLeaves(world, x + rX, y + rY, z + rZ, 1);
        }
        return true;
    }

    public void buildLeaves(World world, int x, int y, int z, int size) {
        Block b = world.func_147439_a(x, y - 2, z);
        Block b1 = world.func_147439_a(x, y - 1, z);
        if (!(b != Blocks.field_150354_m && b1 != Blocks.field_150354_m || ConfigRTG.allowTreesToGenerateOnSand)) {
            return;
        }
        if ((b.func_149688_o() == Material.field_151577_b || b.func_149688_o() == Material.field_151578_c || this.sand && b.func_149688_o() == Material.field_151595_p) && b1 != Blocks.field_150355_j) {
            if (!ConfigRTG.allowShrubsToGenerateBelowSurface && b1.func_149688_o() != Material.field_151579_a && b1.func_149688_o() != Material.field_151582_l && b1.func_149688_o() != Material.field_151585_k && b1 != Blocks.field_150431_aC) {
                return;
            }
            for (int i = -size; i <= size; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        if (Math.abs(i) + Math.abs(j) + Math.abs(k) > size) continue;
                        this.buildBlock(world, x + i, y + j, z + k, this.leaveBlock, this.leaveMeta);
                    }
                }
            }
            world.func_147465_d(x, y - 1, z, this.logBlock, this.logMeta, 0);
        }
    }

    public void buildBlock(World world, int x, int y, int z, Block block, int meta) {
        Block b = world.func_147439_a(x, y, z);
        if (b.func_149688_o() == Material.field_151579_a || b.func_149688_o() == Material.field_151582_l || b.func_149688_o() == Material.field_151585_k || b == Blocks.field_150431_aC) {
            world.func_147465_d(x, y, z, block, meta, 0);
        }
    }
}

