/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.biomesoplenty;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.CliffCalculator;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceBOPCanyon
extends SurfaceBase {
    private int[] claycolor = new int[100];
    private int grassRaise = 0;

    public SurfaceBOPCanyon(BiomeConfig config, Block top, byte topByte, Block fill, byte fillByte, int grassHeight) {
        super(config, top, topByte, fill, fillByte);
        this.grassRaise = grassHeight;
        int[] c = new int[]{1, 8, 0};
        OpenSimplexNoise simplex = new OpenSimplexNoise(2L);
        for (int i = 0; i < 100; ++i) {
            float n = simplex.noise1((float)i / 3.0f) * 3.0f + simplex.noise1((float)i / 1.0f) * 0.3f + 1.5f;
            n = n >= 3.0f ? 2.9f : (n < 0.0f ? 0.0f : n);
            this.claycolor[i] = c[(int)n];
        }
    }

    public byte getClayColorForHeight(int k) {
        k = (k -= 60) < 0 ? 0 : (k > 99 ? 99 : k);
        return this.claycolor[k] == 0 ? (byte)12 : (byte)this.claycolor[k];
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.3f;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth > -1 && depth < 12) {
                if (cliff) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = this.getClayColorForHeight(k);
                    continue;
                }
                if (depth > 4) {
                    blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
                    metadata[(y * 16 + x) * 256 + k] = this.getClayColorForHeight(k);
                    continue;
                }
                if (k > 74 + this.grassRaise) {
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                    continue;
                }
                if (k < 62) {
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                    continue;
                }
                if (k < 62 + this.grassRaise) {
                    if (depth == 0) {
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                    continue;
                }
                if (k < 75 + this.grassRaise) {
                    if (depth == 0) {
                        int r = (int)((float)(k - (62 + this.grassRaise)) / 2.0f);
                        if (rand.nextInt(r + 1) == 0) {
                            blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                            metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                            continue;
                        }
                        if (rand.nextInt((int)((float)r / 2.0f) + 1) == 0) {
                            blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                            metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                            continue;
                        }
                        blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                        metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                    continue;
                }
                if (depth == 0) {
                    blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                continue;
            }
            if (k <= 63) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150406_ce;
            metadata[(y * 16 + x) * 256 + k] = this.getClayColorForHeight(k);
        }
    }
}

