/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.TerrainBase;

public class BumpyHillsEffect
extends HeightEffect {
    public float hillHeight = 2.1474836E9f;
    public float hillWavelength = 0.0f;
    public float spikeHeight = 2.1474836E9f;
    public float spikeWavelength = 0.0f;
    public int hillOctave = 0;
    public int spikeOctave = 2;

    @Override
    public final float added(OpenSimplexNoise simplex, CellNoise cell, float x, float y) {
        float noise = simplex.octave(this.hillOctave).noise2(x / this.hillWavelength, y / this.hillWavelength);
        noise = TerrainBase.blendedHillHeight(noise);
        float spikeNoise = simplex.octave(this.spikeOctave).noise2(x / this.spikeWavelength, y / this.spikeWavelength);
        spikeNoise = TerrainBase.blendedHillHeight(spikeNoise * noise);
        return noise * this.hillHeight + spikeNoise * this.spikeHeight;
    }
}

