/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightEffect;

public class VariableRuggednessEffect
extends HeightEffect {
    public HeightEffect smoothTerrain;
    public HeightEffect ruggedTerrain;
    public float startTransition = 2.1474836E9f;
    public float transitionWidth = 0.0f;
    public int octave = 1;
    public float wavelength;
    public static float STANDARD_RUGGEDNESS_WAVELENGTH = 200.0f;
    public static int STANDARD_RUGGEDNESS_OCTAVE = 1;

    public VariableRuggednessEffect() {
    }

    public VariableRuggednessEffect(HeightEffect smoothTerrain, HeightEffect ruggedTerrain, float startTransition, float transitionWidth, float wavelength) {
        this.smoothTerrain = smoothTerrain;
        this.ruggedTerrain = ruggedTerrain;
        this.startTransition = startTransition;
        this.transitionWidth = transitionWidth;
        this.wavelength = wavelength;
    }

    public VariableRuggednessEffect(HeightEffect smoothTerrain, HeightEffect ruggedTerrain, float startTransition, float transitionWidth) {
        this(smoothTerrain, ruggedTerrain, startTransition, transitionWidth, STANDARD_RUGGEDNESS_WAVELENGTH);
    }

    @Override
    public final float added(OpenSimplexNoise simplex, CellNoise cell, float x, float y) {
        float choice = simplex.octave(this.octave).noise2(x / this.wavelength, y / this.wavelength);
        if (choice <= this.startTransition) {
            return this.smoothTerrain.added(simplex, cell, x, y);
        }
        if (choice >= this.startTransition + this.transitionWidth) {
            return this.ruggedTerrain.added(simplex, cell, x, y);
        }
        float smooth = this.smoothTerrain.added(simplex, cell, x, y);
        float rugged = this.ruggedTerrain.added(simplex, cell, x, y);
        return ((choice - this.startTransition) * rugged + (this.startTransition + this.transitionWidth - choice) * smooth) / this.transitionWidth;
    }
}

