/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.enhancedbiomes;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.JitterEffect;
import rtg.world.gen.terrain.SpikeEffect;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainEBWastelands
extends TerrainBase {
    private float baseHeight = 66.0f;
    private float spikeHeight = 15.0f;
    private float spikeWavelength = 25.0f;
    private float jitterAmplitude = 4.0f;
    private float jitterWavelength = 15.0f;
    private HeightEffect height;

    public TerrainEBWastelands() {
        SpikeEffect spikes = new SpikeEffect();
        spikes.height = this.spikeHeight;
        spikes.minimumSimplex = 0.3f;
        spikes.wavelength = this.spikeWavelength;
        JitterEffect jitter = new JitterEffect();
        jitter.amplitude = this.jitterAmplitude;
        jitter.wavelength = this.jitterWavelength;
        jitter.jittered = spikes;
        this.height = jitter;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainEBWastelands.riverized(this.height.added(simplex, cell, x, y) + this.baseHeight, river);
    }
}

