/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLAutumnForest
extends TerrainBase {
    private float start;
    private float height;
    private float width;
    private float wavelength = 15.0f;
    private float amplitude = 2.0f;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();

    public TerrainHLAutumnForest(float hillStart, float landHeight, float baseHeight, float hillWidth) {
        this.start = hillStart;
        this.height = landHeight;
        this.base = baseHeight;
        this.width = hillWidth;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / this.wavelength, (float)y / this.wavelength, this.jitter);
        float pX = (float)((double)x + this.jitter.deltax() * (double)this.amplitude);
        float pY = (float)((double)y + this.jitter.deltay() * (double)this.amplitude);
        float h = TerrainHLAutumnForest.blendedHillHeight(Math.abs(simplex.noise2(pX / this.width, pY / this.width)), 0.3f) * this.height * river;
        float f = h = h < this.start ? this.start + (h - this.start) / 4.5f : h;
        if (h > 0.0f) {
            float st = h * 1.5f > 15.0f ? 15.0f : h * 1.5f;
            h += TerrainHLAutumnForest.blendedHillHeight((float)simplex.noise((double)pX / 70.0, (double)pY / 70.0, 1.0)) * st;
        }
        h = TerrainHLAutumnForest.above(h, 10.0f);
        return TerrainHLAutumnForest.riverized(this.base + (h += TerrainHLAutumnForest.groundNoise(pX, pY, 4.0f, simplex)), river);
    }
}

