/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLBadlands
extends TerrainBase {
    private float hHeight;
    private float hWidth;
    private float vHeight;
    private float vWidth;
    private float bHeight;
    public static float mountainStart = 30.0f;
    private float lakeWaterLevel = 0.08f;
    private float lakeDepressionLevel = 0.2f;

    public TerrainHLBadlands(float hillHeight, float hillWidth, float varHeight, float varWidth, float baseHeight) {
        this.hHeight = hillHeight;
        this.hWidth = hillWidth;
        this.vHeight = varHeight;
        this.vWidth = varWidth;
        this.bHeight = baseHeight;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / this.vWidth, (float)y / this.vWidth) * this.vHeight * river;
        h += simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float m = simplex.noise2((float)x / this.hWidth, (float)y / this.hWidth) * this.hHeight * river;
        m *= m / 40.0f;
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f;
        float cm = cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * 12.0f;
        m += (cm *= m / 20.0f > 3.75f ? 3.75f : (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)) / 20.0f);
        m += simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 3.0f;
        m += simplex.noise2((float)x / 5.0f, (float)y / 5.0f) * 1.5f;
        m = TerrainHLBadlands.above(m, mountainStart);
        h += simplex.noise2((float)x / 100.0f, (float)y / 100.0f) * 2.0f;
        float channelPressure = this.channelPressure(simplex, cell, x, y, border);
        if (h + m > 20.0f) {
            channelPressure = 0.0f;
        } else if (h + m > 0.0f) {
            channelPressure = 1.0f - (1.0f - channelPressure) * (20.0f - m - h) / 20.0f;
        }
        float channelFlattening = this.channelFlattening(channelPressure, this.lakeWaterLevel, this.lakeDepressionLevel);
        channelFlattening = 1.0f - TerrainHLBadlands.borderAdjusted(1.0f - channelFlattening, border, 0.8f, 0.5f);
        float result = TerrainHLBadlands.riverized(this.bHeight + h + m + TerrainHLBadlands.groundNoise(x, y, 2.0f, simplex), channelFlattening);
        return TerrainHLBadlands.riverized(result, river);
    }

    public float channelPressure(OpenSimplexNoise simplex, CellNoise simplexCell, int x, int y, float border) {
        SimplexOctave.Disk jitter = new SimplexOctave.Disk();
        simplex.riverJitter().evaluateNoise((double)x / 60.0, (double)y / 60.0, jitter);
        double pX = (double)x + jitter.deltax() * 35.0;
        double pY = (double)y + jitter.deltay() * 35.0;
        simplex.riverJitter().evaluateNoise((double)x / 10.0, (float)y / 10.0f, jitter);
        double[] results = simplexCell.river().eval((pX += jitter.deltax() * 3.0) / 250.0, (pY += jitter.deltay() * 3.0) / 250.0);
        if ((double)border < 0.5) {
            border = 0.5f;
        }
        float result = (float)((results[1] - results[0]) / results[1]);
        return result;
    }

    public float channelFlattening(float pressure, float bottomLevel, float topLevel) {
        if (pressure > this.lakeDepressionLevel) {
            return 1.0f;
        }
        if (pressure < this.lakeWaterLevel) {
            return 0.0f;
        }
        return (pressure - this.lakeWaterLevel) / (this.lakeDepressionLevel - this.lakeWaterLevel);
    }
}

