/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLOutback
extends TerrainBase {
    private float valley;
    private int wavelength = 20;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();
    private double amplitude = 5.0;

    public TerrainHLOutback(float valleySize) {
        this.valley = valleySize;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
        float pX = (int)Math.round((double)x + this.jitter.deltax() * this.amplitude);
        float pY = (int)Math.round((double)y + this.jitter.deltay() * this.amplitude);
        return TerrainHLOutback.terrainDuneValley(pX, pY, simplex, cell, river, this.valley, 65.0f, 70.0f);
    }
}

