/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLPinelands
extends TerrainBase {
    private float baseHeight = 76.0f;
    private float peakyHillWavelength = 60.0f;
    private float peakyHillStrength = 50.0f;
    private float smoothHillWavelength = 85.0f;
    private float smoothHillStrength = 20.0f;
    private SimplexOctave.Derivative jitter = new SimplexOctave.Derivative();
    private float wavelength = 12.0f;
    private float amplitude = 4.0f;

    public TerrainHLPinelands() {
    }

    public TerrainHLPinelands(float bh, float hs) {
        this.baseHeight = bh;
        this.peakyHillStrength = hs;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        this.groundNoise = TerrainHLPinelands.groundNoise(x, y, this.groundNoiseAmplitudeHills, simplex);
        simplex.riverJitter().evaluateNoise((float)x / this.wavelength, (float)y / this.wavelength, this.jitter);
        int pX = (int)Math.round((double)x + this.jitter.deltax() * (double)this.amplitude);
        int pY = (int)Math.round((double)y + this.jitter.deltay() * (double)this.amplitude);
        float h = TerrainHLPinelands.terrainGrasslandHills(pX, pY, simplex, cell, river, this.peakyHillWavelength, this.peakyHillStrength, this.smoothHillWavelength, this.smoothHillStrength, this.baseHeight);
        return this.groundNoise * river + h;
    }
}

