/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLRainforest
extends TerrainBase {
    private float width;
    private float strength;
    private float terrainHeight;
    private static float startCliffsAt = 40.0f;
    private int wavelength = 20;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();
    private double amplitude = 5.0;

    public TerrainHLRainforest(float mountainHeight, float mountainWidth, float depthLake) {
        this(mountainWidth, mountainHeight, depthLake, 260.0f, 78.0f);
    }

    public TerrainHLRainforest(float mountainWidth, float mountainStrength, float depthLake, float widthLake, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.terrainHeight = height;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
        int pX = (int)Math.round((double)x + this.jitter.deltax() * this.amplitude);
        int pY = (int)Math.round((double)y + this.jitter.deltay() * this.amplitude);
        x = pX;
        y = pY;
        float h = simplex.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        h += simplex.noise2((float)x / 7.0f, (float)y / 7.0f) * 0.8f;
        float m = simplex.noise2((float)x / this.width, (float)y / this.width) * this.strength * river;
        m *= m / 35.0f;
        m = m > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float st = m * 0.7f;
        st = st > 20.0f ? 20.0f : st;
        float c = (float)simplex.noise((float)x / 30.0f, (float)y / 30.0f, 1.0) * (3.0f + st);
        float sm = simplex.noise2((float)x / 15.0f, (float)y / 15.0f) * 4.0f + simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f;
        m += (sm *= (m + 10.0f) / 20.0f > 2.5f ? 2.5f : (m + 10.0f) / 20.0f);
        m += c;
        m = TerrainHLRainforest.above(m, startCliffsAt);
        float result = this.terrainHeight + h + m;
        if (river < 1.0f) {
            return 62.0f + (result - 62.0f) * river;
        }
        return result;
    }
}

