/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLSteppe
extends TerrainBase {
    private float hHeight;
    private float hWidth;
    private float vHeight;
    private float vWidth;
    private float bHeight;
    public static float mountainStart = 30.0f;

    public TerrainHLSteppe(float hillHeight, float hillWidth, float varHeight, float varWidth, float baseHeight) {
        this.hHeight = hillHeight;
        this.hWidth = hillWidth;
        this.vHeight = varHeight;
        this.vWidth = varWidth;
        this.bHeight = baseHeight;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float h = simplex.noise2((float)x / this.vWidth, (float)y / this.vWidth) * this.vHeight * river;
        h += TerrainHLSteppe.blendedHillHeight(simplex.noise2((float)x / 20.0f, (float)y / 20.0f), -0.3f) * 2.0f;
        float m = simplex.noise2((float)x / this.hWidth, (float)y / this.hWidth) * this.hHeight * river;
        m *= m / 40.0f;
        float sm = simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * 8.0f;
        float cm = cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * 12.0f;
        m += (cm *= m / 20.0f > 3.75f ? 3.75f : (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)) / 20.0f);
        m += simplex.noise2((float)x / 12.0f, (float)y / 12.0f) * 3.0f;
        m += simplex.noise2((float)x / 5.0f, (float)y / 5.0f) * 1.5f;
        m = TerrainHLSteppe.above(m, mountainStart);
        return TerrainHLSteppe.riverized(this.bHeight + (h += TerrainHLSteppe.blendedHillHeight(simplex.noise2((float)x / 100.0f, (float)y / 100.0f), -0.3f) * 2.0f) + m, river);
    }
}

