/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.util.SimplexOctave;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLWoodsMountains
extends TerrainBase {
    private float width;
    private float strength;
    private float terrainHeight;
    private int wavelength = 40;
    private SimplexOctave.Disk jitter = new SimplexOctave.Disk();
    private double amplitude = 10.0;

    public TerrainHLWoodsMountains(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.terrainHeight = height;
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        simplex.riverJitter().evaluateNoise((float)x / (float)this.wavelength, (float)y / (float)this.wavelength, this.jitter);
        int pX = (int)Math.round((double)x + this.jitter.deltax() * this.amplitude);
        int pY = (int)Math.round((double)y + this.jitter.deltay() * this.amplitude);
        x = pX;
        y = pY;
        return TerrainHLWoodsMountains.terrainLonelyMountain(x, y, simplex, cell, river, this.strength, this.width, this.terrainHeight);
    }
}

