/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.vanilla;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.HeightEffect;
import rtg.world.gen.terrain.JitterEffect;
import rtg.world.gen.terrain.MountainsWithPassesEffect;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainVanillaExtremeHillsPlus
extends TerrainBase {
    private float width;
    private float strength;
    private float spikeWidth = 40.0f;
    private float spikeHeight = 70.0f;
    private HeightEffect heightEffect;

    public TerrainVanillaExtremeHillsPlus(float mountainWidth, float mountainStrength, float height) {
        this.width = mountainWidth;
        this.strength = mountainStrength;
        this.base = height;
        MountainsWithPassesEffect mountainEffect = new MountainsWithPassesEffect();
        mountainEffect.mountainHeight = this.strength;
        mountainEffect.mountainWavelength = this.width;
        mountainEffect.spikeHeight = this.spikeHeight;
        mountainEffect.spikeWavelength = this.spikeWidth;
        this.heightEffect = new JitterEffect(7.0f, 10.0f, mountainEffect);
        this.heightEffect = new JitterEffect(3.0f, 6.0f, this.heightEffect);
    }

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        return TerrainVanillaExtremeHillsPlus.riverized(this.heightEffect.added(simplex, cell, x, y) + this.base, river);
    }
}

