/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.util.Tools;
import de.maxhenkel.gravestone.util.UpdateChecker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class UpdateCheckEvents {
    private static final String UPDATE_CHECK_URL = "http://maxhenkel.de/update/gravestone_1.7.10.txt";
    private static final String UPDATE_URL = "http://minecraft.curseforge.com/projects/gravestone-mod";
    private boolean checkUpdates;
    private boolean updateShown;

    public UpdateCheckEvents() {
        this.checkUpdates = Config.instance().checkUpdates;
        this.updateShown = false;
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        if (!event.world.field_72995_K) {
            return;
        }
        final EntityPlayer player = (EntityPlayer)event.entity;
        if (player.field_70128_L) {
            return;
        }
        if (!this.checkUpdates) {
            return;
        }
        if (this.updateShown) {
            return;
        }
        UpdateChecker checker = new UpdateChecker(new UpdateChecker.IUpdateCheckResult(){

            @Override
            public void onResult(boolean isAvailable) {
                if (isAvailable) {
                    UpdateCheckEvents.this.showUpdateMessage(player);
                }
            }
        }, 27, UPDATE_CHECK_URL);
        checker.start();
        this.updateShown = true;
    }

    private void showUpdateMessage(EntityPlayer player) {
        String msg = "[" + Tools.translate("message.name", new Object[0]) + "] " + Tools.translate("message.update", new Object[0]) + " ";
        ClickEvent openUrl = new ClickEvent(ClickEvent.Action.OPEN_URL, UPDATE_URL);
        ChatStyle style = new ChatStyle();
        style.func_150241_a(openUrl);
        style.func_150228_d(Boolean.valueOf(true));
        style.func_150238_a(EnumChatFormatting.GREEN);
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(Tools.translate("message.update.hover", new Object[0]))));
        ChatComponentText comp = new ChatComponentText("[Download]");
        comp.func_150255_a(style);
        player.func_145747_a(new ChatComponentText(msg).func_150257_a((IChatComponent)comp));
    }
}

