/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.asm;

import com.austinv11.collectiveframework.minecraft.CollectiveFramework;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Transformer
implements IClassTransformer,
Opcodes {
    public static boolean didCheck = false;
    public static boolean isDev = false;
    private static int procreationHookCounter = 1;

    public byte[] transform(String className, String newClassName, byte[] byteCode) {
        if (className.equals("net.minecraft.client.gui.FontRenderer")) {
            CollectiveFramework.LOGGER.info("Applying color code patch");
            return this.transformFontRenderer(byteCode);
        }
        if (className.equals("net.minecraft.client.renderer.entity.RenderEnchantmentTable")) {
            CollectiveFramework.LOGGER.info("Hooking into RenderEnchantmentTable#renderTileEntityAt(Lnet/minecraft/tileentity/TileEntityEnchantmentTable;DDDF)V");
            return this.transformRenderEnchantmentTable(byteCode);
        }
        if (className.equals("net.minecraft.client.gui.GuiMainMenu")) {
            CollectiveFramework.LOGGER.info("Hooking into GuiMainMenu#initGui()V");
            return this.transformGuiMainMenu(byteCode);
        }
        if (className.equals("net.minecraft.entity.passive.EntityAnimal") || className.equals("net.minecraft.entity.ai.EntityAIMate")) {
            CollectiveFramework.LOGGER.info("Adding hooks procreation hooks (" + procreationHookCounter + "/2)");
            ++procreationHookCounter;
            return this.transformProcreation(byteCode);
        }
        return byteCode;
    }

    private byte[] transformRenderEnchantmentTable(byte[] byteCode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(byteCode);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!this.checkDeobfAndObfNames(m.name, "renderTileEntityAt", "func_147500_a") || !m.desc.contains("TileEntityEnchantmentTable")) continue;
            for (AbstractInsnNode node : m.instructions) {
                if (node.getOpcode() != 178) continue;
                InsnList instructions = new InsnList();
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/ClientHooks", "getBookTexture", "(Lnet/minecraft/tileentity/TileEntityEnchantmentTable;)Lnet/minecraft/util/ResourceLocation;", false));
                instructions.add((AbstractInsnNode)new VarInsnNode(58, 7));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
                m.instructions.insertBefore(node, instructions);
                m.instructions.remove(node);
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformFontRenderer(byte[] byteCode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(byteCode);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!this.checkDeobfAndObfNames(m.name, "renderStringAtPos", "func_78255_a")) continue;
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/ClientHooks", "getStringToRender", "(Ljava/lang/String;)Ljava/lang/String;", false));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
            m.instructions.insert(instructions);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformGuiMainMenu(byte[] byteCode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(byteCode);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!this.checkDeobfAndObfNames(m.name, "initGui", "func_73866_w_")) continue;
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/ClientHooks", "click", "()V", false));
            m.instructions.insert(instructions);
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] transformProcreation(byte[] byteCode) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(byteCode);
        classReader.accept((ClassVisitor)classNode, 0);
        int invokeVirtualCounter = 0;
        for (MethodNode m : classNode.methods) {
            if (this.checkDeobfAndObfNames(m.name, "procreate", "func_70876_c")) {
                for (AbstractInsnNode node : m.instructions) {
                    InsnList instructions;
                    if (node.getOpcode() == 58) {
                        instructions = new InsnList();
                        instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/CommonHooks", "procreatePre", "(Lnet/minecraft/entity/EntityAgeable;Lnet/minecraft/entity/passive/EntityAnimal;Lnet/minecraft/entity/passive/EntityAnimal;)Lnet/minecraft/entity/EntityAgeable;", false));
                        instructions.add((AbstractInsnNode)new VarInsnNode(58, 2));
                        m.instructions.insert(node, instructions);
                        continue;
                    }
                    if (node.getOpcode() != 182) continue;
                    if (invokeVirtualCounter != 9) {
                        ++invokeVirtualCounter;
                        continue;
                    }
                    instructions = new InsnList();
                    instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/CommonHooks", "procreatePost", "(Lnet/minecraft/entity/EntityAgeable;Lnet/minecraft/entity/passive/EntityAnimal;Lnet/minecraft/entity/passive/EntityAnimal;)V", false));
                    m.instructions.insert(node, instructions);
                }
            } else {
                if (!this.checkDeobfAndObfNames(m.name, "spawnBaby", "func_75388_i")) continue;
                for (AbstractInsnNode node : m.instructions) {
                    InsnList instructions;
                    if (node.getOpcode() == 58) {
                        instructions = new InsnList();
                        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIMate", "targetMate", "Lnet/minecraft/entity/passive/EntityAnimal;"));
                        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIMate", "targetMate", "Lnet/minecraft/entity/passive/EntityAnimal;"));
                        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/CommonHooks", "procreatePre", "(Lnet/minecraft/entity/EntityAgeable;Lnet/minecraft/entity/passive/EntityAnimal;Lnet/minecraft/entity/passive/EntityAnimal;)Lnet/minecraft/entity/EntityAgeable;", false));
                        instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
                        m.instructions.insert(node, instructions);
                        continue;
                    }
                    if (node.getOpcode() != 182) continue;
                    if (invokeVirtualCounter != 9) {
                        ++invokeVirtualCounter;
                        continue;
                    }
                    instructions = new InsnList();
                    instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIMate", "targetMate", "Lnet/minecraft/entity/passive/EntityAnimal;"));
                    instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/ai/EntityAIMate", "targetMate", "Lnet/minecraft/entity/passive/EntityAnimal;"));
                    instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/austinv11/collectiveframework/minecraft/hooks/CommonHooks", "procreatePost", "(Lnet/minecraft/entity/EntityAgeable;Lnet/minecraft/entity/passive/EntityAnimal;Lnet/minecraft/entity/passive/EntityAnimal;)V", false));
                    m.instructions.insert(node, instructions);
                }
            }
            break;
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private boolean checkDeobfAndObfNames(String input, String deobf, String obf) {
        if (!didCheck && (input.equals(deobf) || input.equals(obf))) {
            didCheck = true;
            isDev = input.equals(deobf);
        }
        return input.equals(deobf) || input.equals(obf);
    }
}

