/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.network;

import com.austinv11.collectiveframework.minecraft.config.ConfigLoadEvent;
import com.austinv11.collectiveframework.minecraft.config.ConfigRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class ConfigPacket
implements IMessage {
    public String configName;
    public String config;
    public boolean isRevert;

    public ConfigPacket() {
    }

    public ConfigPacket(String configName, String config, boolean isRevert) {
        this.configName = configName;
        this.config = config;
        this.isRevert = isRevert;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.configName = tag.func_74779_i("configName");
        this.config = tag.func_74779_i("config");
        this.isRevert = tag.func_74767_n("isRevert");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("configName", this.configName);
        tag.func_74778_a("config", this.config);
        tag.func_74757_a("isRevert", this.isRevert);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class ConfigPacketHandler
    implements IMessageHandler<ConfigPacket, IMessage> {
        public IMessage onMessage(ConfigPacket message, MessageContext ctx) {
            ConfigLoadEvent.Pre event = new ConfigLoadEvent.Pre();
            event.configName = message.configName;
            event.config = message.config;
            event.isRevert = message.isRevert;
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                ConfigRegistry.onConfigReload(event);
                ConfigLoadEvent.Post newEvent = new ConfigLoadEvent.Post();
                newEvent.configName = event.configName;
                newEvent.config = event.config;
                newEvent.isRevert = event.isRevert;
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
            return null;
        }
    }
}

