/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import com.austinv11.collectiveframework.minecraft.CollectiveFramework;
import com.austinv11.collectiveframework.utils.StringUtils;
import com.austinv11.collectiveframework.utils.WebUtils;
import com.google.gson.Gson;

public class CurseVersionChecker {
    public static final String BASE_API_URL = "http://widget.mcf.li/mc-mods/minecraft/@MOD@.json";
    private final String curseId;
    private final String name;
    private final String url;
    private CurseWidgetResponse check;
    private boolean didCheck = false;

    public CurseVersionChecker(String curseId, String name) {
        this.curseId = curseId;
        this.name = name;
        this.url = BASE_API_URL.replace("@MOD@", curseId);
    }

    private void doCheckIfNescessary() {
        if (this.check == null) {
            try {
                Gson gson = new Gson();
                String response = StringUtils.stringFromList(WebUtils.readURL(this.url));
                this.check = (CurseWidgetResponse)gson.fromJson(response, CurseWidgetResponse.class);
            }
            catch (Exception e) {
                CollectiveFramework.LOGGER.error("A problem has occurred attempting to retrieve mod update info");
                e.printStackTrace();
            }
        }
    }

    public boolean isUpdateAvailable() {
        this.doCheckIfNescessary();
        return !this.check.download.name.equals(this.name) && this.check.download.version.equals("1.7.10");
    }

    public String getDownloadUrl() {
        this.doCheckIfNescessary();
        return "http://minecraft.curseforge.com/mc-mods/" + this.curseId + "/files/" + this.check.download.id + "/download";
    }

    public String getUpdateFileName() {
        this.doCheckIfNescessary();
        return this.check.download.name;
    }

    public String getProjectUrl() {
        this.doCheckIfNescessary();
        return this.check.project_url;
    }

    private static class Download {
        public int id;
        public String url;
        public String name;
        public String type;
        public String version;
        public int downloads;
        public String created_at;

        private Download() {
        }
    }

    private static class Downloads {
        public int monthly;
        public int total;

        private Downloads() {
        }
    }

    private static class CurseWidgetResponse {
        public String title;
        public String game;
        public String category;
        public String url;
        public String thumbnail;
        public String[] authors;
        public Downloads downloads;
        public int favorites;
        public int likes;
        public String updated_at;
        public String created_at;
        public String project_url;
        public String release_type;
        public String license;
        public Download download;

        private CurseWidgetResponse() {
        }
    }
}

