/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.multithreading;

import com.austinv11.collectiveframework.multithreading.SimpleThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SimpleRunnable
implements Runnable {
    public static volatile boolean RESTRICT_THREAD_USAGE = true;
    private static volatile ConcurrentHashMap<Boolean, ConcurrentHashMap<Integer, SimpleThread>> threadMap = new ConcurrentHashMap();
    private volatile boolean isCleaned = false;
    private volatile int thread = -1;
    private volatile long delay = -1L;

    public final void disable(boolean clean) throws IllegalThreadStateException {
        if (this.isCleaned) {
            throw new IllegalThreadStateException("Thread " + this.getName() + " is cleaned already!");
        }
        this.getThread().isActive = false;
        this.getThread().delay = -1L;
        this.getThread().started = false;
        if (clean && RESTRICT_THREAD_USAGE) {
            this.isCleaned = true;
            SimpleRunnable.add((Map)threadMap.get(false), this.getThread());
            threadMap.get(true).remove(this.thread);
        }
    }

    public final void enable() throws IllegalThreadStateException {
        if (this.isCleaned) {
            throw new IllegalThreadStateException("Thread " + this.getName() + " is cleaned already!");
        }
        this.getThread().isActive = true;
        this.getThread().delay = this.delay;
        this.getThread().started = true;
    }

    public final void start() {
        this.getThread().start();
    }

    @Override
    public abstract void run();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public final void delay(int delay) throws InterruptedException {
        this.getThread().wait(delay);
    }

    public boolean isCleaned() {
        return this.isCleaned;
    }

    public boolean isEnabled() {
        return this.getThread().isActive;
    }

    public void setTicking(long delay) {
        this.delay = delay;
        this.getThread().delay = delay;
    }

    private final SimpleThread getThread() {
        if (this.thread == -1) {
            if (threadMap.get(false).size() < 1) {
                SimpleThread thread = new SimpleThread(this, this.getName());
                this.thread = SimpleRunnable.add((Map)threadMap.get(true), thread);
                return this.getThread();
            }
            Map.Entry<Integer, SimpleThread> entry = threadMap.get(false).entrySet().iterator().next();
            SimpleThread thread = entry.getValue();
            threadMap.get(false).remove(entry.getKey());
            thread.isActive = true;
            thread.setName(this.getName());
            try {
                thread.setTarget(this);
                this.thread = SimpleRunnable.add((Map)threadMap.get(true), thread);
                return this.getThread();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return threadMap.get(true).get(this.thread);
        }
        return null;
    }

    private static <T> int add(Map<Integer, T> map, T o) {
        int i = 0;
        while (map.containsKey(i)) {
            ++i;
        }
        map.put(i, o);
        return i;
    }

    public boolean equals(Object other) {
        if (other instanceof SimpleRunnable) {
            return ((SimpleRunnable)other).thread == this.thread && ((SimpleRunnable)other).getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        return "SimpleRunnable(Name: " + this.getName() + " ID:" + this.thread + " Is Cleaned: " + this.isCleaned + ")";
    }

    static {
        threadMap.put(true, new ConcurrentHashMap());
        threadMap.put(false, new ConcurrentHashMap());
    }
}

