/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.multithreading;

import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import java.lang.reflect.Field;

public class SimpleThread
extends Thread {
    public volatile boolean isActive = true;
    public volatile long delay = -1L;
    public volatile boolean started = false;

    protected SimpleThread() {
    }

    protected SimpleThread(Runnable target) {
        super(target);
    }

    protected SimpleThread(ThreadGroup group, Runnable target) {
        super(group, target);
    }

    protected SimpleThread(String name) {
        super(name);
    }

    protected SimpleThread(ThreadGroup group, String name) {
        super(group, name);
    }

    protected SimpleThread(Runnable target, String name) {
        super(target, name);
    }

    protected SimpleThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
    }

    protected SimpleThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
    }

    @Override
    public void run() {
        do {
            if (!this.started) continue;
            if (this.delay == -1L) {
                if (!this.isActive) continue;
                super.run();
                continue;
            }
            while (this.isActive) {
                super.run();
                try {
                    if (!this.isActive || this.delay < 0L) continue;
                    SimpleThread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } while (SimpleRunnable.RESTRICT_THREAD_USAGE);
    }

    @Override
    public synchronized void start() {
        int status = -1;
        this.started = true;
        try {
            status = this.getStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (status != 0) {
            this.isActive = true;
        } else {
            super.start();
        }
    }

    public void setTarget(Runnable runnable) throws NoSuchFieldException, IllegalAccessException {
        Field field = Thread.class.getDeclaredField("target");
        field.setAccessible(true);
        field.set(this, runnable);
    }

    private Integer getStatus() throws NoSuchFieldException, IllegalAccessException {
        Field field = Thread.class.getDeclaredField("threadStatus");
        field.setAccessible(true);
        return (Integer)field.get(this);
    }

    public boolean equals(Object other) {
        return other instanceof SimpleThread && this.getName().equals(((SimpleThread)other).getName());
    }

    @Override
    public String toString() {
        return "SimpleThread(Name: " + this.getName() + " Is Active: " + this.isActive + ")";
    }
}

