/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.utils.EntityUtil;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.lepidopterology.genetics.LepidopteristTracker;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class ButterflyHelper
extends SpeciesRoot
implements IButterflyRoot {
    private static int butterflySpeciesCount = -1;
    public static final String UID = "rootButterflies";
    private static final ArrayList<IButterfly> butterflyTemplates = new ArrayList();
    private static final ArrayList<IButterflyMutation> butterflyMutations = new ArrayList();

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return IButterfly.class;
    }

    @Override
    public int getSpeciesCount() {
        if (butterflySpeciesCount < 0) {
            butterflySpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleButterflySpecies) || !((IAlleleButterflySpecies)entry.getValue()).isCounted()) continue;
                ++butterflySpeciesCount;
            }
        }
        return butterflySpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return this.getType(stack) != EnumFlutterType.NONE;
    }

    @Override
    public EnumFlutterType getType(ItemStack stack) {
        if (stack == null) {
            return EnumFlutterType.NONE;
        }
        Item item = stack.func_77973_b();
        if (PluginLepidopterology.items.butterflyGE == item) {
            return EnumFlutterType.BUTTERFLY;
        }
        if (PluginLepidopterology.items.serumGE == item) {
            return EnumFlutterType.SERUM;
        }
        if (PluginLepidopterology.items.caterpillarGE == item) {
            return EnumFlutterType.CATERPILLAR;
        }
        return EnumFlutterType.NONE;
    }

    @Override
    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    @Override
    public IButterfly getMember(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!this.isMember(stack)) {
            return null;
        }
        return new Butterfly(stack.func_77978_p());
    }

    @Override
    public IButterfly getMember(NBTTagCompound compound) {
        return new Butterfly(compound);
    }

    @Override
    public ItemStack getMemberStack(IIndividual butterfly, int type) {
        ItemButterflyGE butterflyItem;
        switch (EnumFlutterType.VALUES[type]) {
            case SERUM: {
                butterflyItem = PluginLepidopterology.items.serumGE;
                break;
            }
            case CATERPILLAR: {
                butterflyItem = PluginLepidopterology.items.caterpillarGE;
                break;
            }
            default: {
                butterflyItem = PluginLepidopterology.items.butterflyGE;
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        butterfly.writeToNBT(nbttagcompound);
        ItemStack stack = new ItemStack((Item)butterflyItem);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    public EntityButterfly spawnButterflyInWorld(World world, IButterfly butterfly, double x, double y, double z) {
        return EntityUtil.spawnEntity(world, new EntityButterfly(world, butterfly), x, y, z);
    }

    @Override
    public boolean isMated(ItemStack stack) {
        IButterfly butterfly = this.getMember(stack);
        if (butterfly == null) {
            return false;
        }
        return butterfly.getMate() != null;
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] template) {
        return new Butterfly(this.templateAsGenome(template));
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Butterfly(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] template) {
        return new ButterflyGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new ButterflyGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public ArrayList<IButterfly> getIndividualTemplates() {
        return butterflyTemplates;
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return MothDefinition.Brimstone.getTemplate();
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        butterflyTemplates.add(ButterflyManager.butterflyRoot.templateAsIndividual(template));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        butterflyMutations.add((IButterflyMutation)mutation);
    }

    @Override
    public Collection<IButterflyMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(butterflyMutations);
        }
        return butterflyMutations;
    }

    @Override
    public ILepidopteristTracker getBreedingTracker(World world, GameProfile player) {
        String filename = "LepidopteristTracker." + (player == null ? "common" : player.getId());
        LepidopteristTracker tracker = (LepidopteristTracker)world.func_72943_a(LepidopteristTracker.class, filename);
        if (tracker == null) {
            tracker = new LepidopteristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        tracker.setUsername(player);
        tracker.setWorld(world);
        return tracker;
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumButterflyChromosome.values();
    }

    @Override
    public IChromosomeType getKaryotypeKey() {
        return EnumButterflyChromosome.SPECIES;
    }
}

